#!/system/bin/sh
MODDIR=${0%/*}

while [ -z "$(getprop sys.boot_completed)" ]; do
	sleep 1
done

# Disable thermal zones
chmod 644 /sys/class/thermal/thermal_zone*/mode
for zone in /sys/class/thermal/thermal_zone*/mode; do
    [ -f "$zone" ] && echo "disabled" > "$zone"
done

for zone2 in /sys/class/thermal/thermal_zone*/policy; do
    [ -f "$zone2" ] && echo "step_wise" > "$zone2"
done

thermal() {
    find /system/etc/init /vendor/etc/init /odm/etc/init -type f 2>/dev/null | xargs grep -h "^service" | awk '{print $2}' | grep thermal
}

thermal_service=$(thermal)

if [ "$thermal_service" != "vendor.thermal-hal" ] && [ "$thermal_service" != "android.hardware.thermal-service.mediatek" ]; then
    stop "$thermal_service"
    sleep 0.5
    pid=$(pidof "$thermal_service")
    if [ -n "$pid" ]; then
        kill -9 "$pid"
    fi
fi

# GPU Power Disable Limited
if [ -f "/proc/gpufreq/gpufreq_power_limited" ]; then
    for setting in ignore_batt_oc ignore_batt_percent ignore_low_batt ignore_thermal_protect ignore_pbm_limited; do
        echo "$setting 1" > /proc/gpufreq/gpufreq_power_limited
    done
fi

# CPU Limit
if [ -f /sys/devices/virtual/thermal/thermal_message/cpu_limits ]; then
    for cpu in 0 2 4 6 7; do
        maxfreq_path="/sys/devices/system/cpu/cpu$cpu/cpufreq/cpuinfo_max_freq"
        if [ -f "$maxfreq_path" ]; then
            maxfreq=$(cat "$maxfreq_path")
            if [ -n "$maxfreq" ] && [ "$maxfreq" -gt 0 ]; then
                echo "cpu$cpu $maxfreq" > /sys/devices/virtual/thermal/thermal_message/cpu_limits
            fi
        fi
    done
fi

# Policy PPM
if [ -d /proc/ppm ]; then
    if [ -f /proc/ppm/policy_status ]; then
        for idx in $(grep -E 'FORCE_LIMIT|PWR_THRO|THERMAL' /proc/ppm/policy_status | awk -F'[][]' '{print $2}'); do
            echo "$idx 0" > /proc/ppm/policy_status
        done
    fi
fi

# Hide thermal monitoring
find /sys/devices/virtual/thermal -type f -exec chmod 000 {} \;

# Disable thermal stats
cmd thermalservice override-status 0

# Disable charging-related throttling if the file exists
if [ -f /proc/mtk_batoc_throttling/battery_oc_protect_stop ]; then
    echo "stop 1" > /proc/mtk_batoc_throttling/battery_oc_protect_stop
fi

# Reset thermal properties
getprop | awk -F '[][]' '/ro.*thermal/ {print $2}' | while read -r prop; do
    resetprop -n "$prop" 0
done

for prop in $(getprop | grep thermal | cut -f1 -d] | cut -f2 -d[ | grep -F init.svc.); do
    setprop "$prop" stopped
done

for prop in $(getprop | grep thermal | cut -f1 -d] | cut -f2 -d[ | grep -F init.svc_); do
    setprop "$prop" ""
done
