#!/system/bin/sh

#Disabled Log
# stop log visibility app
  for app in $(pm list packages|grep com.|cut -d ":" -f2);do pm log-visibility --disable "$app";cmd dropbox add-low-priority "$app";done
  
# add dropbox low priority
  for process in "${PROCESS[@]}";do cmd dropbox add-low-priority "$process";done

# stop log device_config
  for device_config in $(cmd device_config list|grep log|cut -d= -f1);do cmd device_config put "${device_config%%/*}" "${device_config#*/}" "0";done

# stop logging process
  for keyword in "${KEYWORDS[@]}";do pids=$(pgrep -f "$keyword"); echo "$pids" | xargs -r pkill -9;done; ps -eo pid,cmd | grep -i log | grep -v grep | while read -r pid cmd; do pkill -9 "$pid"&done

# disable log.tag/persist.log
  for log in $(getprop|cut -f1 -d']'|cut -f2 -d'['|grep -E '^(log\.tag\.|persist\.log\.)');do setprop "$log" "S";done

# dropbox cleaner @HoyoSlave
  for a in $(cmd settings list secure|grep dropbox|cut -f1 -d=);do cmd settings delete secure "$a";cmd dropbox
  wm tracing level critical;wm tracing size 0
  
# disable log in secure
  if settings list secure | grep "upload_log_pref"; then write secure upload_debug_log_pref 0; write secure upload_log_pref 0; fi

# run fstrim every reboot
  write global fstrim_mandatory_interval 1

# disable jank monitoring
  device_config put interaction_jank_monitor enabled false

# stop log visibility app
  for app in $(pm list packages|grep com.|cut -d ":" -f2);do pm log-visibility --disable "$app";cmd dropbox add-low-priority "$app";done

# disable log in global
  if settings list global | grep "activity_starts_logging_enabled"; then write global activity_starts_logging_enabled 0; fi && if settings list global | grep "autofill_logging_level"; then write global autofill_logging_level 0; fi && if settings list global | grep "enable_diskstats_logging"; then write global enable_diskstats_logging 0; fi && if settings list global | grep "foreground_service_starts_logging_enabled"; then write global foreground_service_starts_logging_enabled 0; fi && if settings list global | grep "nene_log"; then write global nene_log 0; fi

# Disable various display logs
cmd display ab-logging-disable
cmd display dwb-logging-disable
cmd display dmd-logging-disable
cmd looper_stats disable

# Run simpleperf with minimal logging
simpleperf --log fatal --log-to-android-buffer 0

# Disable app log visibility and deprioritize logging
for app in $(pm list packages | grep com. | cut -d ":" -f2); do
  pm log-visibility --disable "$app"
  cmd dropbox add-low-priority "$app"
done

# Matikan konfigurasi logging dari device_config
for config in $(cmd device_config list | grep log | cut -d= -f1); do
  namespace="${config%%/*}"
  key="${config#*/}"
  cmd device_config put "$namespace" "$key" "0"
done

# Kill logging-related processes (aman untuk dimatikan)
KEYWORDS=("logd" "logcat" "dropbox" "traced" "statsd")
for keyword in "${KEYWORDS[@]}"; do
  pids=$(pgrep -f "$keyword")
  echo "$pids" | xargs -r pkill -9
done

# Disable log.tag and persist.log properties
for prop in $(getprop | cut -f1 -d']' | cut -f2 -d'[' | grep -E '^(log\.tag\.|persist\.log\.)'); do
  setprop "$prop" "-"
done

# Dropbox cleaner (hapus log sistem & batasi)
for setting in $(cmd settings list secure | grep dropbox | cut -f1 -d=); do
  cmd settings delete secure "$setting"
done
cmd dropbox restore-defaults
cmd dropbox set-rate-limit "999999999"
settings put global dropbox_max_files "1"

# WindowManager tracing minimal
wm tracing level critical
wm tracing size 0

# Menetapkan properti sistem untuk UI Smoother
setprop debug.sf.early.app.duration 20000000
setprop debug.sf.early.sf.duration 20000000
setprop debug.sf.earlyGl.app.duration 20000000
setprop debug.sf.earlyGl.sf.duration 20000000
setprop debug.sf.hwc.min.duration 20000000
setprop debug.sf.late.app.duration 20000000
setprop debug.sf.late.sf.duration 20000000

# Paksa GMS ke Doze Mode
dumpsys deviceidle enable
dumpsys deviceidle force-idle

# Blokir akses latar belakang GMS
appops set com.google.android.gms RUN_IN_BACKGROUND ignore
appops set com.google.android.gms RUN_ANY_IN_BACKGROUND ignore

# Batasi penggunaan CPU GMS
echo 1 > /proc/sys/vm/drop_caches
echo 0 > /dev/cpuctl/apps/com.google.android.gms/cpu.shares
echo 0 > /dev/cpuctl/bg_non_interactive/cpu.shares

# Batasi pemakaian jaringan
iptables -A OUTPUT -p tcp --destination-port 5228 -j DROP
iptables -A OUTPUT -p tcp --destination-port 443 -m owner --uid-owner 1000 -j DROP

# Blokir Alarm Wakeup dari GMS
settings put global alarm_manager_constants min_interval=600000,allow_while_idle_short_time=2000,allow_while_idle_long_time=10000

# Percepat Doze Mode
settings put global device_idle_constants inactive_to=60000,sensing_to=0,locating_to=0,motion_inactive_to=0,idle_after_inactive_to=120000,idle_to=300000,max_idle_to=1800000,min_time_to_alarm=900000

# Unlock Performa Maximal
(
debug.performance.tuning 1
cmd thermalservice override-status 0
cmd power set-fixed-performance-mode-enabled true
cmd power set-adaptive-power-saver-enabled false
cmd power set-mode 0
cmd device_config put thermal high_temp_limit 150
cmd device_config put thermal low_temp_limit 150
cmd shortcut reset-throttling
cmd shortcut reset-all-throttling
) > /dev/null 2>&1 &

#disble Costume Rom
su -c pm disable com.android.cellbroadcastreceiver.module
su -c pm disable com.android.healthconnect.controller
su -c pm disable com.caf.fmradio
su -c pm disable org.omnirom.omnijaws
su -c pm disable org.omnirom.logcat
su -c pm disable io.chaldeaprjkt.gamespace
su -c pm disable org.lineageos.audiofx
su -c pm disable com.stevesoltys.seedvault
su -c pm disable org.lineageos.setupwizard
su -c pm disable com.google.android.syncadapters.calendar
su -c pm disable com.android.dreams.phototable
su -c pm disable com.android.gallery3d
su -c pm disable com.android.calculator2
su -c pm disable org.lineageos.recorder
su -c pm disable org.lineageos.glimpse
su -c pm disable org.lineageos.etar
su -c pm disable org.lineageos.jelly
su -c pm disable org.lineageos.twelve
su -c pm disable com.android.angle
su -c pm disable com.android.bookmarkprovider
su -c pm disable com.android.printspooler
su -c pm disable com.android.wallpaper.livepicker
su -c pm disable com.android.providers.calendar
su -c pm disable com.android.bips
su -c pm disable com.android.apps.tag
su -c pm disable com.google.android.contactkeys
su -c pm disable com.google.ar.core
su -c pm disable com.google.android.safetycore
su -c pm disable com.google.android.ims
su -c pm disable com.google.android.markup
su -c pm disable com.simplemobiletools.calendar.pro
su -c pm disable com.duckduckgo.mobile.android
su -c pm disable com.android.emergency
su -c pm disable org.eu.droid_ng.jellyfish
su -c pm disable com.voltage.flash
su -c pm disable com.google.android.pixel.setupwizard
su -c pm disable com.google.android.apps.restore
su -c pm disable com.google.android.setupwizard
su -c pm disable com.google.android.partnersetup
su -c pm disable com.google.android.feedback
su -c pm disable com.google.android.videos
su -c pm disable com.google.android.apps.turbo
su -c pm disable com.google.pixel.livewallpaper
su -c pm disable com.google.assistant.hubui
su -c pm disable com.google.android.apps.work.clouddpc
su -c pm disable com.google.android.aicore
su -c pm disable com.google.android.calendar

# Disable Limit Perf Pada Costume Rom
(
pm disable-user --user 0 com.android.providers.settings
pm disable-user --user 0 com.android.server.telecom
pm disable-user --user 0 com.android.power
pm disable-user --user 0 com.android.providers.downloads
pm disable-user --user 0 com.android.providers.media
pm disable-user --user 0 com.android.providers.syncml
pm disable-user --user 0 com.android.providers.contacts
pm disable-user --user 0 com.android.thermaldaemon
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Xiaomi
(
pm disable-user --user 0 com.xiaomi.joyose
pm disable-user --user 0 com.miui.msa.global
pm disable-user --user 0 com.miui.analytics
pm disable-user --user 0 com.miui.daemon
pm disable-user --user 0 com.miui.yellowpage
pm disable-user --user 0 com.xiaomi.mipicks
pm disable-user --user 0 com.mi.globalbrowser
pm disable-user --user 0 com.miui.securitycenter
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Oppo/Realme
(
pm disable-user --user 0 com.oppo.market
pm disable-user --user 0 com.heytap.market
pm disable-user --user 0 com.heytap.browser
pm disable-user --user 0 com.heytap.themestore
pm disable-user --user 0 com.coloros.securityguard
pm disable-user --user 0 com.coloros.hotapps
pm disable-user --user 0 com.coloros.hotgames
pm disable-user --user 0 com.oppo.community
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Samsung
(
pm disable-user --user 0 com.samsung.android.voc
pm disable-user --user 0 com.samsung.android.bixby.agent
pm disable-user --user 0 com.sec.android.app.sbrowser
pm disable-user --user 0 com.sec.android.app.shealth
pm disable-user --user 0 com.samsung.android.email.provider
pm disable-user --user 0 com.samsung.android.arzone
pm disable-user --user 0 com.samsung.sree
pm disable-user --user 0 com.samsung.android.oneconnect
pm disable-user --user 0 com.samsung.android.app.notes
pm disable-user --user 0 com.samsung.android.tvplus
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Asus
(
pm disable-user --user 0 com.asus.mobilemanager.transfer
pm disable-user --user 0 com.asus.weathertime
pm disable-user --user 0 com.asus.healthfitness
pm disable-user --user 0 com.asus.launcher
pm disable-user --user 0 com.google.android.apps.tachyon
pm disable-user --user 0 com.asus.filemanager
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Infinix
(
pm disable-user --user 0 com.infinix.xshare
pm disable-user --user 0 com.transsion.phonemaster.store
pm disable-user --user 0 com.transsion.phoenix
pm disable-user --user 0 com.infinix.yoparty
pm disable-user --user 0 com.afmobi.boomplay
pm disable-user --user 0 com.transsion.phonemaster
pm disable-user --user 0 com.transsion.hitranslate
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Vivo
(
pm disable-user --user 0 com.vivo.securedaemonservice
pm disable-user --user 0 com.vivo.appstore
pm disable-user --user 0 com.vivo.browser
pm disable-user --user 0 com.vivo.ai.assistant
pm disable-user --user 0 com.vivo.bbk.cloud
pm disable-user --user 0 com.vivo.easyshare
pm disable-user --user 0 com.vivo.game
pm disable-user --user 0 com.vivo.email
pm disable-user --user 0 com.vivo.hotapps
pm disable-user --user 0 com.vivo.hotgames
pm disable-user --user 0 com.vivo.services
pm disable-user --user 0 com.vivo.pushservice
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Itel
(
pm disable-user --user 0 com.transsion.phonemaster.store
pm disable-user --user 0 com.transsion.phoenix
pm disable-user --user 0 com.transsion.phonemaster
pm disable-user --user 0 com.ahagame.center
pm disable-user --user 0 com.afmobi.boomplay
pm disable-user --user 0 com.transsion.vishaplayer
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Honor / Huawei
(
pm disable-user --user 0 com.huawei.browser
pm disable-user --user 0 com.huawei.intelligent
pm disable-user --user 0 com.huawei.hicloud
pm disable-user --user 0 com.huawei.music
pm disable-user --user 0 com.huawei.health
pm disable-user --user 0 com.huawei.systemmanager
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Sony
(
pm disable-user --user 0 com.sonyericsson.music
pm disable-user --user 0 com.playstation.mobile
pm disable-user --user 0 com.sonyericsson.lounge
pm disable-user --user 0 com.sonyericsson.smartconnect
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada Tecno
(
pm disable-user --user 0 com.transsion.appstore
pm disable-user --user 0 com.transsion.phonemaster
pm disable-user --user 0 com.transsion.music
pm disable-user --user 0 com.transsion.gamecenter
pm disable-user --user 0 com.transsion.weather
) > /dev/null 2>&1 &

# Menonaktifkan aplikasi pada ZTE
(
pm disable-user --user 0 com.zte.appstore
pm disable-user --user 0 com.zte.systemmanager
pm disable-user --user 0 com.zte.music
pm disable-user --user 0 com.zte.weather
) > /dev/null 2>&1 &