#!/system/bin/sh

# Restore the original thermal configuration

THERMAL_CONFIGS=(
  "/system/vendor/etc/thermal-engine.conf"
  "/vendor/etc/thermal-engine.conf"
  "/system/etc/thermal-engine.conf"
)

for THERMAL_CONFIG in "${THERMAL_CONFIGS[@]}"; do
  THERMAL_CONFIG_BAK="${THERMAL_CONFIG}.bak"
  if [ -f $THERMAL_CONFIG_BAK ]; then
    mv $THERMAL_CONFIG_BAK $THERMAL_CONFIG
    echo "Restored original thermal configuration in $THERMAL_CONFIG."
  else
    echo "Backup thermal configuration not found for $THERMAL_CONFIG!"
  fi
done
