#!/system/bin/sh
MODDIR=${0%/*}
while [ -z "$(getprop sys.boot_completed)" ]; do
    sleep 10
done


DEVICE_NAME=$(getprop ro.product.model)

su -lp 2000 -c "cmd notification post -t 'Mediatek Performance' \
    'core' 'Performance mode applied on $DEVICE_NAME'" >/dev/null 2>&1 &
  
     
# Get the number of CPU cores 
cpucores=`grep -c ^processor /proc/cpuinfo`
cpusint=`echo $((cpucores-1))`

for i in `seq 0 $cpusint`; do
    chmod 0644 /sys/devices/system/cpu/cpu$i/cpufreq/scaling_min_freq
    echo $(cat /sys/devices/system/cpu/cpu$i/cpufreq/scaling_max_freq) > /sys/devices/system/cpu/cpu$i/cpufreq/scaling_min_freq
done

# Force performance governor di semua core
for cpu in /sys/devices/system/cpu/cpu[0-9]*; do
    if [ -f "$cpu/cpufreq/scaling_min_freq" ] && [ -f "$cpu/cpufreq/scaling_max_freq" ]; then
        max_freq=$(cat "$cpu/cpufreq/cpuinfo_max_freq")
        echo $max_freq > "$cpu/cpufreq/scaling_min_freq"
        echo $max_freq > "$cpu/cpufreq/scaling_max_freq"
    fi
done

chmod 0755 /sys/devices/system/cpu/cpu*
chmod 0644 /sys/devices/system/cpu/cpufreq/policy0/scaling_governor
chmod 0644 /sys/devices/system/cpu/cpufreq/policy6/scaling_governor 
chmod 0644 /sys/devices/system/cpu/cpufreq/schedutil/*
echo "performance" > /sys/devices/system/cpu/cpu[0-9]*
echo "performance" > /sys/devices/system/cpu/cpufreq/policy0/scaling_governor 
echo "performance" > /sys/devices/system/cpu/cpufreq/policy6/scaling_governor

# Force all cores online
for i in /sys/devices/system/cpu/cpu[1-9]*/online; do
  echo 1 > $i 2>/dev/null
done

# Disable core hotplug 
if [ -f /sys/module/msm_hotplug/msm_enabled ]; then
    echo 0 > /sys/module/msm_hotplug/msm_enabled
fi

if [ -f /sys/module/autosmp/parameters/enabled ]; then
    echo 0 > /sys/module/autosmp/parameters/enabled
fi

# Disable printk only
echo "0 0 0 0" > /proc/sys/kernel/printk

# Fps Go
    echo "1" > /sys/module/mtk_fpsgo/parameters/uboost_enhance_f
    echo "90" > /sys/module/mtk_fpsgo/parameters/rescue_enhance_f
    echo "1" > /sys/module/mtk_fpsgo/parameters/qr_mod_frame
    echo "1" > /sys/module/mtk_fpsgo/parameters/fstb_consider_deq
    echo "5" > /sys/pnpmgr/fpsgo_boost/fstb/fstb_tune_quantile
    echo "0" > /sys/pnpmgr/fpsgo_boost/fstb/fstb_tune_error_threshold
    echo "10" > /sys/pnpmgr/fpsgo_boost/fbt/bhr_opp
    echo 90 > /sys/module/mtk_fpsgo/parameters/bhr
    echo "0" > /sys/pnpmgr/fpsgo_boost/fbt/floor_opp
    echo "90" > /sys/pnpmgr/fpsgo_boost/fbt/rescue_enhance_f
    echo "100" > /sys/module/mtk_fpsgo/parameters/run_time_percent
    echo "1" > /sys/module/mtk_fpsgo/parameters/loading_ignore_enable
    echo "20" > /sys/module/mtk_fpsgo/parameters/kmin
    echo 2 > /sys/kernel/fpsgo/fstb/margin_mode_gpu
    echo "26" > /sys/pnpmgr/fpsgo_boost/fbt/rescue_opp_c
    echo 0 > /sys/module/mtk_fpsgo/parameters/check_running
    echo 7 >/sys/module/mtk_fpsgo/parameters/xgf_ema_dividend
    echo "26" > /sys/pnpmgr/fpsgo_boost/fbt/rescue_opp_f
    echo "90" > /sys/pnpmgr/fpsgo_boost/fbt/rescue_percent
    echo "1" > /sys/pnpmgr/fpsgo_boost/fbt/ultra_rescue
    echo 1900 > sys/kernel/fpsgo/fbt/blc_boost
    echo 0 > /sys/module/ged/parameters/gpu_cust_upbound_freq
    echo 100 > /sys/module/ged/parameters/gpu_cust_boost_freq
    echo 100 > /sys/module/mtk_fpsgo/parameters/gcc_up_sec_pct
    echo 100 > /sys/module/mtk_fpsgo/parameters/gcc_up_step
    echo 1 > /sys/module/mtk_fpsgo/parameters/gcc_hwui_hint
    echo 15 > /sys/kernel/gbe/gbe2_max_boost_cnt
    echo 100 > /sys/kernel/fpsgo/fbt/thrm_temp_th

    # Set FPSGO fstb parameters
    echo 1 > /sys/kernel/fpsgo/fstb/boost_ta
    echo 0 > /sys/kernel/fpsgo/fstb/enable_switch_sync_flag
    echo 1 > /sys/kernel/fpsgo/fbt/boost_VIP
    echo 0 > /sys/kernel/fpsgo/fstb/gpu_slowdown_check
    echo 0 > /sys/kernel/fpsgo/fbt/thrm_limit_cpu
    echo 2 > /sys/kernel/fpsgo/fbt/llf_task_policy
    echo 0 > /sys/kernel/fpsgo/fbt/thrm_limit_cpu

    #Set GPU boost level
    echo -1 > /sys/kernel/ged/hal/gpu_boost_level

    # Set GED parameters
    echo 1 > /sys/module/ged/parameters/ged_smart_boost
    echo 1 > /sys/module/ged/parameters/ged_boost_enable
    echo 0 > /sys/module/ged/parameters/is_GED_KPI_enabled

    # Set additional GPU boost parameters
    echo 1 > /sys/module/ged/parameters/gx_frc_mode
    echo 1 > /sys/module/ged/parameters/gx_boost_on
    echo 1 > /sys/module/ged/parameters/gx_game_mode
    echo 1 > /sys/module/ged/parameters/gx_3D_benchmark_on
    echo 1 > /sys/module/ged/parameters/cpu_boost_policy
    echo 1 > /sys/module/ged/parameters/boost_extra

    # Set PNPMGR parameters
    echo 1 > /sys/pnpmgr/install
    echo 1 > /sys/pnpmgr/mwn

    # Set MTK FPSGo parameters
    echo 1 > /sys/module/mtk_fpsgo/parameters/boost_affinity
    echo 1 > /sys/module/mtk_fpsgo/parameters/boost_LR
    echo 1 > /sys/module/mtk_fpsgo/parameters/xgf_uboost
    echo 1 > /sys/module/mtk_fpsgo/parameters/xgf_extra_sub
    echo 4 > /sys/module/mtk_fpsgo/parameters/xgf_stddev_multi
    echo 1 > /sys/module/mtk_fpsgo/parameters/gcc_enable

# Cache jangan cepat dibuang
if [ -f  /proc/sys/vm/vfs_cache_pressure ]; then
  echo 50 > /proc/sys/vm/vfs_cache_pressure

# Jangan bunuh proses foreground tiba2
for LMK in /sys/module/lowmemorykiller/parameters/; do
  echo 0 > $LMK/enable_adaptive_lmk 2>/dev/null
  echo 1000 > $LMK/minfree 2>/dev/null
  echo 1 > $LMK/oom_reaper 2>/dev/null
done

# Jika ada thermal config (if)
if [ -f sys/module/msm_thermal/core_control/enabled 2>/dev/null ]; then
  echo N > sys/module/msm_thermal/core_control/enabled 2>/dev/null
fi

# TCP Signal
echo 1 > /proc/sys/net/ipv4/tcp_tw_reuse
echo 1 > /proc/sys/net/ipv4/tcp_sack
echo 1 > /proc/sys/net/ipv4/tcp_low_latency

# schedtune boost
echo 1 > /dev/stune/top-app/schedtune.boost 2>/dev/null
echo 1 > /dev/stune/top-app/schedtune.prefer_idle 2>/dev/null
echo 1 > /dev/stune/foreground/schedtune.boost 2>/dev/null

echo 1 > /dev/stune/foreground/schedtune.prefer_idle 2>/dev/null
echo 1 > /dev/stune/top-app/schedtune.prefer_idle 2>/dev/null

# Lebih agresif kasih CPU time ke game
echo 95 > /proc/sys/kernel/sched_upmigrate
echo 85 > /proc/sys/kernel/sched_downmigrate
echo 1  > /proc/sys/kernel/sched_boost

# Lebih smooth saat streaming chunk
for blk in /sys/block/*/queue/; do
  echo 0 > $blk/rotational 2>/dev/null
  echo 0 > $blk/add_random 2>/dev/null
  echo 0 > $blk/iostats 2>/dev/null
  echo cfq > $blk/scheduler 2>/dev/null
done

# VM
# Lebih agresif pakai RAM, kurangi swap
for ramt in /proc/sys/vm/; do
  echo 10 > $ramt/swappiness
  echo 1 > $ramt/overcommit_memory
  echo 100 > $ramt/vfs_cache_pressure
done