#!/system/bin/sh
# uninstall.sh - restore CPU governor saat module dihapus

log() { echo "[magisk-cpu-perf][uninstall] $1"; }

reset_governor() {
  CPU_DIR="$1"
  GAV="$CPU_DIR/cpufreq/scaling_available_governors"
  G_CUR="$CPU_DIR/cpufreq/scaling_governor"
  G_MIN="$CPU_DIR/cpufreq/scaling_min_freq"
  G_MAX="$CPU_DIR/cpufreq/scaling_max_freq"

  [ ! -f "$GAV" ] && return 0

  AVAIL=$(cat "$GAV")

  # coba balikkan ke schedutil, kalau ada
  if echo "$AVAIL" | grep -qw schedutil; then
    echo schedutil > "$G_CUR" 2>/dev/null && log "Reset $CPU_DIR → schedutil"
  elif echo "$AVAIL" | grep -qw ondemand; then
    echo ondemand > "$G_CUR" 2>/dev/null && log "Reset $CPU_DIR → ondemand"
  else
    FIRST=$(echo $AVAIL | awk '{print $1}')
    [ -n "$FIRST" ] && echo "$FIRST" > "$G_CUR" 2>/dev/null && log "Reset $CPU_DIR → $FIRST"
  fi

  # kembalikan min ke paling rendah, max ke paling tinggi
  if [ -f "$CPU_DIR/cpufreq/cpuinfo_min_freq" ] && [ -f "$CPU_DIR/cpufreq/cpuinfo_max_freq" ]; then
    MINF=$(cat "$CPU_DIR/cpufreq/cpuinfo_min_freq")
    MAXF=$(cat "$CPU_DIR/cpufreq/cpuinfo_max_freq")
    echo "$MINF" > "$G_MIN" 2>/dev/null
    echo "$MAXF" > "$G_MAX" 2>/dev/null
    log "Reset $CPU_DIR min/max → $MINF / $MAXF"
  fi
}

for CPU in /sys/devices/system/cpu/cpu[0-9]*; do
  reset_governor "$CPU" &
done
wait

log "CPU governor & frekuensi sudah dikembalikan ke default."

# cleanup runtime setprops
setprop debug.sf.latch_unsignaled 0
setprop debug.sf.set_idle_timer_ms 0
setprop debug.sf.frame_rate_multiple_threshold 0
# no guaranteed way to remove system.prop changes; uninstall via Magisk will remove module files
exit 0

# Uninstall script SurfaceBoost

# Balikin priority process default
if pidof surfaceflinger >/dev/null; then
    renice 0 -p `pidof surfaceflinger`
fi
if pidof system_server >/dev/null; then
    renice 0 -p `pidof system_server`
fi

# Balikin cpuset default (umumnya 0-7 semua core)
if [ -d /dev/cpuset ]; then
    echo 0-7 > /dev/cpuset/background/cpus
    echo 0-7 > /dev/cpuset/foreground/cpus
    echo 0-7 > /dev/cpuset/top-app/cpus
fi

# Matikan input boost (balik default)
if [ -d /sys/module/cpu_boost/parameters ]; then
    echo 0 > /sys/module/cpu_boost/parameters/input_boost_enabled 2>/dev/null
fi

# Hapus persist property kalau ada
resetprop --delete ro.surface_flinger.max_frame_buffer_acquired_buffers
resetprop --delete ro.surface_flinger.max_virtual_display_dimension
resetprop --delete debug.sf.disable_backpressure
resetprop --delete debug.hwui.disable_vsync
resetprop --delete debug.hwui.render_dirty_regions
resetprop --delete persist.sys.gpu.rendering
resetprop --delete persist.sys.ui.hw

#!/system/bin/sh
# Uninstaller for Boost + Smooth + Encore-style tweaks
# Will try to restore sane defaults

# CPU scheduler defaults
echo 100 > /proc/sys/kernel/sched_upmigrate 2>/dev/null
echo 85  > /proc/sys/kernel/sched_downmigrate 2>/dev/null
echo 0   > /proc/sys/kernel/sched_boost 2>/dev/null

# CPU hotplug/cores
for i in /sys/devices/system/cpu/cpu[1-9]*/online; do
  echo 1 > $i 2>/dev/null
done
echo 1 > /sys/module/msm_hotplug/msm_enabled 2>/dev/null
echo 1 > /sys/module/autosmp/parameters/enabled 2>/dev/null

# GPU governor back to default (ondemand or msm-adreno-tz usually)
if [ -d /sys/class/kgsl/kgsl-3d0 ]; then
  if grep -q "msm-adreno-tz" /sys/class/kgsl/kgsl-3d0/devfreq/available_governors 2>/dev/null; then
    echo msm-adreno-tz > /sys/class/kgsl/kgsl-3d0/devfreq/governor 2>/dev/null
  elif grep -q "ondemand" /sys/class/kgsl/kgsl-3d0/devfreq/available_governors 2>/dev/null; then
    echo ondemand > /sys/class/kgsl/kgsl-3d0/devfreq/governor 2>/dev/null
  fi

  # reset force flags
  echo 0 > /sys/class/kgsl/kgsl-3d0/force_clk_on 2>/dev/null
  echo 0 > /sys/class/kgsl/kgsl-3d0/force_bus_on 2>/dev/null
  echo 0 > /sys/class/kgsl/kgsl-3d0/force_rail_on 2>/dev/null
fi

# I/O defaults
for blk in /sys/block/*/queue/; do
  echo 1 > $blk/add_random 2>/dev/null
  echo 1 > $blk/iostats 2>/dev/null
  if grep -q "cfq" $blk/scheduler 2>/dev/null; then
    echo cfq > $blk/scheduler 2>/dev/null
  elif grep -q "noop" $blk/scheduler 2>/dev/null; then
    echo noop > $blk/scheduler 2>/dev/null
  fi
done

# VM defaults
echo 60  > /proc/sys/vm/swappiness 2>/dev/null
echo 0   > /proc/sys/vm/overcommit_memory 2>/dev/null
echo 100 > /proc/sys/vm/vfs_cache_pressure 2>/dev/null

# LMK defaults
echo 1 > /sys/module/lowmemorykiller/parameters/enable_adaptive_lmk 2>/dev/null
echo 0 > /sys/module/lowmemorykiller/parameters/oom_reaper 2>/dev/null

# Thermal back
echo Y > /sys/module/msm_thermal/core_control/enabled 2>/dev/null

# SchedTune defaults
for path in /dev/stune/*; do
  [ -d "$path" ] || continue
  echo 0 > $path/schedtune.boost 2>/dev/null
  echo 0 > $path/schedtune.prefer_idle 2>/dev/null
done

# Binder debug reset
echo 7 > /dev/binderfs/binder_logs/debug_mask 2>/dev/null

# Done
exit 0

#!/system/bin/sh
# uninstall.sh - attempt to clear props set by this module
MODDIR=${0%/*}
LOG="$MODDIR/magisk-sf.log"
echo "[SF-MOD][`date +'%H:%M:%S'`] uninstall start" >> $LOG

echo "[SF-MOD][`date +'%H:%M:%S'`] uninstall done" >> $LOG