#!/system/bin/sh
# post-fs-data.sh - executed very early
MODDIR=${0%/*}

# ensure executable
chmod 0755 $MODDIR/service.sh
chmod 0755 $MODDIR/uninstall.sh

# System props tweak (aktif sejak awal)
resetprop ro.config.low_ram false
resetprop dalvik.vm.heapsize 512m
resetprop dalvik.vm.heapgrowthlimit 256m
resetprop dalvik.vm.heaptargetutilization 0.75
resetprop dalvik.vm.heapminfree 2m
resetprop dalvik.vm.heapmaxfree 8m

# Display tweaks
resetprop debug.sf.hw 1
resetprop debug.sf.latch_unsignaled 1
resetprop debug.sf.disable_backpressure 1
resetprop debug.sf.disable_hwc_vds 1
resetprop ro.surface_flinger.force_hwc_copy_for_virtual_displays true

# run service in background (if magisk v > 14 this runs as root)
# Use nohup to survive early init
if [ -x "$MODDIR/service.sh" ]; then
  nohup sh $MODDIR/service.sh >/dev/null 2>&1 &
fi
# post-fs-data.sh - set governor early

log() { echo "[magisk-cpu-perf] $1"; }

set_governor() {
  CPU_DIR="$1"
  GAV="$CPU_DIR/cpufreq/scaling_available_governors"
  G_CUR="$CPU_DIR/cpufreq/scaling_governor"
  G_MIN="$CPU_DIR/cpufreq/scaling_min_freq"
  G_MAX="$CPU_DIR/cpufreq/scaling_max_freq"
  if [ ! -f "$GAV" ]; then
    return 0
  fi

  AVAIL=$(cat "$GAV")
  # prefer performance
  if echo "$AVAIL" | grep -qw performance; then
    echo performance > "$G_CUR" 2>/dev/null && log "Set $CPU_DIR to performance"
  elif echo "$AVAIL" | grep -qw userspace; then
    echo userspace > "$G_CUR" 2>/dev/null && log "Set $CPU_DIR to userspace"
  elif echo "$AVAIL" | grep -qw ondemand; then
    echo ondemand > "$G_CUR" 2>/dev/null && log "Set $CPU_DIR to ondemand (fallback)"
  else
    # fallback to first available governor
    FIRST=$(echo $AVAIL | awk '{print $1}')
    [ -n "$FIRST" ] && echo "$FIRST" > "$G_CUR" 2>/dev/null && log "Set $CPU_DIR to $FIRST (fallback)"
  fi

  # try lock min/max to max available freq if paths exist
  if [ -f "$G_MAX" ] && [ -f "$G_MIN" ]; then
    MAXF=$(cat "$CPU_DIR/cpufreq/cpuinfo_max_freq" 2>/dev/null)
    if [ -n "$MAXF" ]; then
      echo "$MAXF" > "$G_MAX" 2>/dev/null && echo "$MAXF" > "$G_MIN" 2>/dev/null
      log "Locked $CPU_DIR min/max to $MAXF"
    fi
  fi
}

for CPU in /sys/devices/system/cpu/cpu[0-9]*; do
  set_governor "$CPU" &
done

wait
log "post-fs-data done"

