#!/system/bin/sh
# Try to set real-time scheduler tweaks (optional)
apply_kernel_tweaks() {
# Apply SF tweaks and kernel tweaks
apply_kernel_tweaks

logi "Service finished"

while [ -z "$(getprop sys.boot_completed)" ]; do
    sleep 10
done

DEVICE_NAME=$(getprop ro.product.model)

su -lp 2000 -c "cmd notification post -t 'Mediatek Optimizer' \
    'core' 'Tweaks applied on $DEVICE_NAME'" >/dev/null 2>&1 &

# service.sh - enforce governor/freq periodically

log() { echo "[magisk-cpu-perf][svc] $1"; }

apply_once() {
  for CPU in /sys/devices/system/cpu/cpu[0-9]*; do
    GAV="$CPU/cpufreq/scaling_available_governors"
    G_CUR="$CPU/cpufreq/scaling_governor"
    G_MIN="$CPU/cpufreq/scaling_min_freq"
    G_MAX="$CPU/cpufreq/scaling_max_freq"
    if [ ! -f "$GAV" ]; then
      continue
    fi

    AVAIL=$(cat "$GAV")
    if echo "$AVAIL" | grep -qw performance; then
      echo performance > "$G_CUR" 2>/dev/null
    elif echo "$AVAIL" | grep -qw userspace; then
      echo userspace > "$G_CUR" 2>/dev/null
    fi

    if [ -f "$CPU/cpufreq/cpuinfo_max_freq" ] && [ -f "$G_MAX" ] && [ -f "$G_MIN" ]; then
      MAXF=$(cat "$CPU/cpufreq/cpuinfo_max_freq" 2>/dev/null)
      if [ -n "$MAXF" ]; then
        echo "$MAXF" > "$G_MAX" 2>/dev/null
        echo "$MAXF" > "$G_MIN" 2>/dev/null
      fi
    fi
  done
}

# run in background loop
while true; do
  apply_once
  sleep 10
done

# Fps Go
    echo "1" > /sys/module/mtk_fpsgo/parameters/uboost_enhance_f
    echo "90" > /sys/module/mtk_fpsgo/parameters/rescue_enhance_f
    echo "1" > /sys/module/mtk_fpsgo/parameters/qr_mod_frame
    echo "1" > /sys/module/mtk_fpsgo/parameters/fstb_consider_deq
    echo "5" > /sys/pnpmgr/fpsgo_boost/fstb/fstb_tune_quantile
    echo "0" > /sys/pnpmgr/fpsgo_boost/fstb/fstb_tune_error_threshold
    echo "10" > /sys/pnpmgr/fpsgo_boost/fbt/bhr_opp
    echo 90 > /sys/module/mtk_fpsgo/parameters/bhr
    echo "0" > /sys/pnpmgr/fpsgo_boost/fbt/floor_opp
    echo "90" > /sys/pnpmgr/fpsgo_boost/fbt/rescue_enhance_f
    echo "100" > /sys/module/mtk_fpsgo/parameters/run_time_percent
    echo "1" > /sys/module/mtk_fpsgo/parameters/loading_ignore_enable
    echo "20" > /sys/module/mtk_fpsgo/parameters/kmin
    echo 2 > /sys/kernel/fpsgo/fstb/margin_mode_gpu
    echo "26" > /sys/pnpmgr/fpsgo_boost/fbt/rescue_opp_c
    echo 0 > /sys/module/mtk_fpsgo/parameters/check_running
    echo 7 >/sys/module/mtk_fpsgo/parameters/xgf_ema_dividend
    echo "26" > /sys/pnpmgr/fpsgo_boost/fbt/rescue_opp_f
    echo "90" > /sys/pnpmgr/fpsgo_boost/fbt/rescue_percent
    echo "1" > /sys/pnpmgr/fpsgo_boost/fbt/ultra_rescue
    echo 1900 > sys/kernel/fpsgo/fbt/blc_boost
    echo 0 > /sys/module/ged/parameters/gpu_cust_upbound_freq
    echo 100 > /sys/module/ged/parameters/gpu_cust_boost_freq
    echo 100 > /sys/module/mtk_fpsgo/parameters/gcc_up_sec_pct
    echo 100 > /sys/module/mtk_fpsgo/parameters/gcc_up_step
    echo 1 > /sys/module/mtk_fpsgo/parameters/gcc_hwui_hint
    echo 15 > /sys/kernel/gbe/gbe2_max_boost_cnt
    echo 100 > /sys/kernel/fpsgo/fbt/thrm_temp_th

    # Set FPSGO fstb parameters
    echo 1 > /sys/kernel/fpsgo/fstb/boost_ta
    echo 0 > /sys/kernel/fpsgo/fstb/enable_switch_sync_flag
    echo 1 > /sys/kernel/fpsgo/fbt/boost_VIP
    echo 0 > /sys/kernel/fpsgo/fstb/gpu_slowdown_check
    echo 0 > /sys/kernel/fpsgo/fbt/thrm_limit_cpu
    echo 2 > /sys/kernel/fpsgo/fbt/llf_task_policy
    echo 0 > /sys/kernel/fpsgo/fbt/thrm_limit_cpu

    # Set GPU boost level
    echo -1 > /sys/kernel/ged/hal/gpu_boost_level

    # Set GED parameters
    echo 1 > /sys/module/ged/parameters/ged_smart_boost
    echo 1 > /sys/module/ged/parameters/enable_gpu_boost
    echo 1 > /sys/module/ged/parameters/ged_boost_enable
    echo 1 > /sys/module/ged/parameters/boost_gpu_enable
    echo 1 > /sys/module/ged/parameters/gpu_dvfs_enable
    echo 1 > /sys/module/ged/parameters/gpu_idle
    echo 0 > /sys/module/ged/parameters/is_GED_KPI_enabled

    # Set additional GPU boost parameters
    echo 1 > /sys/module/ged/parameters/gx_frc_mode
    echo 1 > /sys/module/ged/parameters/gx_boost_on
    echo 1 > /sys/module/ged/parameters/gx_game_mode
    echo 1 > /sys/module/ged/parameters/gx_3D_benchmark_on
    echo 1 > /sys/module/ged/parameters/cpu_boost_policy
    echo 1 > /sys/module/ged/parameters/boost_extra

    # Set PNPMGR parameters
    echo 1 > /sys/pnpmgr/install
    echo 1 > /sys/pnpmgr/mwn

    # Set MTK FPSGo parameters
    echo 1 > /sys/module/mtk_fpsgo/parameters/boost_affinity
    echo 1 > /sys/module/mtk_fpsgo/parameters/boost_LR
    echo 1 > /sys/module/mtk_fpsgo/parameters/xgf_uboost
    echo 1 > /sys/module/mtk_fpsgo/parameters/xgf_extra_sub
    echo 4 > /sys/module/mtk_fpsgo/parameters/xgf_stddev_multi
    echo 1 > /sys/module/mtk_fpsgo/parameters/gcc_enable

# ==== I/O Scheduler ====
# Gunakan "noop" atau "deadline" untuk latency rendah
for i in /sys/block/*/queue/scheduler; do
    echo noop > $i 2>/dev/null
done

# ==== Virtual Memory ====
# Kurangi swappiness & pagecache biar lancar
echo 10 > /proc/sys/vm/swappiness
echo 200 > /proc/sys/vm/dirty_writeback_centisecs
echo 0 > /proc/sys/vm/dirty_background_ratio
echo 10 > /proc/sys/vm/dirty_ratio

[ -f /sys/module/workqueue/parameters/debug ] && echo N > /sys/module/workqueue/parameters/debug
[ -f /proc/sys/kernel/printk ] && echo "0 0 0 0" > /proc/sys/kernel/printk

# Disable sched trace
for f in /sys/kernel/debug/tracing/events/sched/*/enable; do
    [ -f "$f" ] && echo 0 > "$f"
done

# Disable workqueue debug
if [ -f /sys/module/workqueue/parameters/debug ]; then
    echo N > /sys/module/workqueue/parameters/debug
fi

# Disable printk (opsional, tapi hati-hati bisa bikin susah debug crash)
echo "0 0 0 0" > /proc/sys/kernel/printk

# Log info
log -t HOPT "Tracing & debug log disabled for performance"

# service.sh - run at boot by Magisk
MODDIR=${0%/*}

log() { echo "[SF60] $*"; }

# wait for property service ready (give some time)
sleep 3

# Optional: try to nudge SurfaceFlinger by restarting it (risky)
# Only uncomment IF you know device tolerates killing surfaceflinger
# log "Restarting surfaceflinger (risky) ..."
# stop surfaceflinger
# sleep 1
# start surfaceflinger

exit 0