#!/system/bin/sh
# uninstall.sh - restore CPU governor saat module dihapus

log() { echo "[magisk-cpu-perf][uninstall] $1"; }

reset_governor() {
  CPU_DIR="$1"
  GAV="$CPU_DIR/cpufreq/scaling_available_governors"
  G_CUR="$CPU_DIR/cpufreq/scaling_governor"
  G_MIN="$CPU_DIR/cpufreq/scaling_min_freq"
  G_MAX="$CPU_DIR/cpufreq/scaling_max_freq"

  [ ! -f "$GAV" ] && return 0

  AVAIL=$(cat "$GAV")

  # coba balikkan ke schedutil, kalau ada
  if echo "$AVAIL" | grep -qw schedutil; then
    echo schedutil > "$G_CUR" 2>/dev/null && log "Reset $CPU_DIR → schedutil"
  elif echo "$AVAIL" | grep -qw ondemand; then
    echo ondemand > "$G_CUR" 2>/dev/null && log "Reset $CPU_DIR → ondemand"
  else
    FIRST=$(echo $AVAIL | awk '{print $1}')
    [ -n "$FIRST" ] && echo "$FIRST" > "$G_CUR" 2>/dev/null && log "Reset $CPU_DIR → $FIRST"
  fi

  # kembalikan min ke paling rendah, max ke paling tinggi
  if [ -f "$CPU_DIR/cpufreq/cpuinfo_min_freq" ] && [ -f "$CPU_DIR/cpufreq/cpuinfo_max_freq" ]; then
    MINF=$(cat "$CPU_DIR/cpufreq/cpuinfo_min_freq")
    MAXF=$(cat "$CPU_DIR/cpufreq/cpuinfo_max_freq")
    echo "$MINF" > "$G_MIN" 2>/dev/null
    echo "$MAXF" > "$G_MAX" 2>/dev/null
    log "Reset $CPU_DIR min/max → $MINF / $MAXF"
  fi
}

for CPU in /sys/devices/system/cpu/cpu[0-9]*; do
  reset_governor "$CPU" &
done
wait

log "CPU governor & frekuensi sudah dikembalikan ke default."

# cleanup runtime setprops
setprop debug.sf.latch_unsignaled 0
setprop debug.sf.set_idle_timer_ms 0
setprop debug.sf.frame_rate_multiple_threshold 0
# no guaranteed way to remove system.prop changes; uninstall via Magisk will remove module files
exit 0

#!/system/bin/sh
# uninstall.sh - attempt to clear props set by this module
MODDIR=${0%/*}
LOG="$MODDIR/magisk-sf.log"
echo "[SF-MOD][`date +'%H:%M:%S'`] uninstall start" >> $LOG

# list of props we tried to set
for p in \
  persist.vendor.display.max_fps \
  persist.vendor.display.maxfps \
  persist.sys.max_refresh_rate \
  persist.sys.max_fps \
  vendor.display.maxfps \
  vendor.display.max_fps \
  persist.display.max_refresh_rate \
  persist.display.max_fps \
  debug.sf.hw \
  debug.sf.disable_early_sync \
  debug.sf.showfps \
  debug.hwui.force_gpu_rendering \
  debug.hwui.force_vsync \
  debug.hwui.disable_vsync \
  ro.surface_flinger.max_frame_buffer_acquired; do
  setprop $p ""
  echo "cleared $p" >> $LOG
done

echo "[SF-MOD][`date +'%H:%M:%S'`] uninstall done" >> $LOG