#!/system/bin/sh

ls /sdcard/Btool/bin/config.ini && DIR="/sdcard/Btool" || DIR=$(cd "$(dirname "$0")" && pwd)
CONFIG_FILE="$DIR/bin/config.ini"
read_config() {
   while IFS='=' read -r lowkey value; do
      [ -z "$lowkey" ] || [ "${lowkey###}" != "$lowkey" ] && continue
      lowkey=$(echo "$lowkey" | tr -d '[:space:]')
      case "$lowkey" in
         game) game="$(echo "$value" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')" ;;
         exapp) exapp="$(echo "$value" | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')" ;;
         *)    value=$(echo "$value" | tr -d '[:space:]') ;;
      esac
      case "$lowkey" in
         FPS) FPS="$value" ;;
      esac
   done < "$CONFIG_FILE"
}
read_config

cpu=65; ms=65; base=15; lockcpuload=70; 

fpss=$(dumpsys SurfaceFlinger | grep "refresh-rate" | awk '{printf "%.0f", $3}')
[ "$fpss" -gt 60 ] && lockbuffer=6 || lockbuffer=3

noop() { setprop "debug.Bnoop.$1" "$2"; }
gnoop() { getprop "debug.Bnoop.$1"; }
c() { cmd "$@"; }
s() { setprop "$1" "$2"; }
d() { device_config "$@"; }
notif() { nice -n 19 cmd notification post --large-icon /sdcard/Btool/Prismatic_Slime.png "$@"; }

set_perf() {
c shortcut reset-throttling & c shortcut reset-all-throttling &
s debug.tracing.ctl.hwui.skia_tracing_enabled true
s debug.tracing.ctl.hwui.skia_use_perfetto_track_events true
s debug.sf.use_frame_rate_priority 1
s debug.composition.type gpu
s debug.egl.hw 1
s debug.sf.hw 1
s debug.sf.multithreaded_present 1
s debug.hwui.render_ahead 1
s debug.sf.enable_adpf_cpu_hint true
s debug.hwui.use_hint_manager true

s debug.sqlite.wal.syncmode OFF
s debug.sqlite.syncmode OFF

c settings put system peak_refresh_rate -1
c settings put system min_refresh_rate 0
c settings put secure user_refresh_rate "$FPS"
c power set-adaptive-power-saver-enabled false
c power set-fixed-performance-mode-enabled true
c power set-mode 0
c thermalservice override-status 0
c settings put system light_speed_app "$tapp" # Thanks to @AduhaiWelewele

d put runtime_native_boot iorap_readahead_enable true
d put surface_flinger_native_boot max_frame_buffer_acquired_buffers $lockbuffer
d put surface_flinger_native_boot adpf_cpu_hint true

c wifi set-scan-always-available disabled
c wifi set-verbose-logging disabled
c wifi set-ipreach-disconnect enabled
c wifi reset-connected-score
c wifi set-connected-score 60
c wifi remove-all-suggestions
c looper_stats disable
c autofill log_level off
c statusbar tracing stop
c activity kill-all
c deviceidle unforce
}

reset_perf() {
s debug.hwui.target_cpu_time_percent 30
s debug.sf.use_frame_rate_priority 0
s debug.composition.type dyn
s debug.egl.hw 0
s debug.sf.hw 0
s debug.sf.multithreaded_present 0
s debug.hwui.render_ahead 0
s debug.sf.enable_adpf_cpu_hint false
s debug.hwui.use_hint_manager false

s debug.sqlite.wal.syncmode NORMAL
s debug.sqlite.syncmode NORMAL

c settings put system peak_refresh_rate 60
c settings put secure user_refresh_rate 60
c settings put system min_refresh_rate 60
c power set-adaptive-power-saver-enabled true
c power set-fixed-performance-mode-enabled false
c power set-mode 1
c thermalservice override-status reset
c settings delete system light_speed_app # thanks to @AduhaiWelewele

d put runtime_native_boot iorap_readahead_enable false
d delete surface_flinger_native_boot max_frame_buffer_acquired_buffers
d delete surface_flinger_native_boot adpf_cpu_hint
c deviceidle force-idle
}

render() {
    c settings put global angle_gl_driver_all_angle 1
    c settings put global game_driver_all_apps 1
    c settings put global updatable_driver_all_apps 1
    c settings put global angle_gl_driver_selection_pkgs "$tapp"
    c settings put global angle_gl_driver_selection_values native
}

get_cpu_load() {
    read cpu user nice system idle iowait irq softirq steal guest guest_nice < /proc/stat
    total1=$((user + nice + system + idle + iowait + irq + softirq + steal))
    idle1=$((idle + iowait))
    sleep 0.12
    read cpu user nice system idle iowait irq softirq steal guest guest_nice < /proc/stat
    total2=$((user + nice + system + idle + iowait + irq + softirq + steal))
    idle2=$((idle + iowait))
    diff_total=$((total2 - total1))
    diff_idle=$((idle2 - idle1))
    load=$(( (100 * (diff_total - diff_idle)) / diff_total ))
    echo "$load"
}

lockcpu() {
#if cpu being use more than lockcpuload , it'setprop gonna hard lock it
	load=$(get_cpu_load)
	if [ "$load" -ge "$lockcpuload" ]; then
	echo $lockcpuload; else
	echo $load; fi
}

binddefer() {
	ms=65; base=13
	calms=$(( (ms * base + (fpss / 2)) / fpss ))
	s debug.sf.cached_set_max_defer_render_attmpts $calms
}

unbinddefer() {
	ms=75; base=150
	calms=$(( (ms * base + (fpss / 2)) / fpss ))
	s debug.sf.cached_set_max_defer_render_attmpts $calms
}

thx_dcx_on() {
multical=$(( 1024 * 1024 * fpss ))
s debug.egl.blobcache.multifile true
s debug.egl.blobcache.multifile_limit $multical
# margin
margincal=$(( 1180 * fpss / 50 ))
s debug.sf.hint_margin_us $margincal
}

thx_dcx_off() {
multical=$(( 24 * 1024 * 1024  ))
s debug.egl.blobcache.multifile true
s debug.egl.blobcache.multifile_limit $multical
# margin
margincal=$(( 420 * fpss / 50 ))
s debug.sf.hint_margin_us $margincal
}

vsync() {
    [ "$fpss" -gt 60 ] && {
        s debug.hwui.disable_vsync true
        s debug.cpurend.vsync false
        s debug.hwc.logvsync 0
        s debug.hwc.fakevsync 0
        s debug.egl.swapinterval 0
        s debug.sf.vsync_reactor_ignore_present_fences true
        s debug.choreographer.vsync false
        s debug.sf.show_predicted_vsync false
    } || for p in \
        "debug.hwui.disable_vsync" \
        "debug.cpurend.vsync" \
        "debug.hwc.logvsync" \
        "debug.hwc.fakevsync" \
        "debug.egl.swapinterval" \
        "debug.sf.vsync_reactor_ignore_present_fences" \
        "debug.choreographer.vsync" \
        "debug.sf.show_predicted_vsync"; do
            s "$p" ""
        done
}

first_setup() {
for a in 1 0; do cmd window scaling off -d $a; done # Turn off window scaling ratio
for a in --supportsNonResizable --respectsActivityMinWidthHeight; do # Force app to resizeable in window
cmd window set-multi-window-config $a 1 ;done
logcat --wrap & logcat -c & pkill -f dumpsys logcat & 
noop reso off
noop device ready
noop gamesec off
}
first_setup

while :; do
  sf=$(c activity stack list|grep 0,0.*visible=true|tr -d ' '|cut -f1 -d/|cut -f2 -d:) # grep app on surface
  recent=$(dumpsys activity recents \
    | grep 'Recent #' \
    | grep -oE 'A=[^ ]+' \
    | cut -d= -f2 \
    | cut -d: -f2 \
    | sort -u) # grep recent app in service

  # ===== Game Optimizer Main Funciton ===== #
  if echo "$game" | grep -qw "$sf"; then
      
      s debug.hwui.target_cpu_time_percent "$load"
      tapp=$sf
      
      noop cycle off
          
      if [ "$(gnoop device)" = ready ]; then
        set_perf; render; binddefer; thx_dcx_on; vsync; 
        notif -S bigtext -t "Bnoop - Boost" test "[ $sf ] Optimized"
        am start -a AxManager.TOAST -e text "$sf [ Boost ]"
        noop device Optimal
        [ "$(getprop ro.product.manufacturer)" = "Xiaomi" ] && { c settings put system POWER_PERFORMANCE_MODE_OPEN 1; c settings put system speed_mode 1; c settings put secure speed_mode_enable 1; c settings put secure miui_refresh_rate "$FPS"; }
      fi
    
  elif [ "$sf" != "$game" ] && echo "$recent" | grep -qw -e $(echo "$game" | sed 's/ / -e /g'); then 
    if [ "$(gnoop cycle)" = on ]; then
      notif -S bigtext -t "Bnoop - Boost" note "Targeted app now not detected on topScreen" 
      am start -a AxManager.TOAST -e text "Targeted app was in Background [ idle ]"
      noop cycle off
    fi
    
  elif [ "$sf" != "$game" ] && [ "$recent" != "$game" ]; then
    if [ "$(gnoop cycle)" = off ]; then
      [ -z "$(gnoop device)" ] && noop device ready
    
      noop cycle on

      if [ "$(gnoop device)" = Optimal ]; then
        reset_perf; unbinddefer; thx_dcx_off; vsync; noop device ready
        notif -S bigtext -t "Bnoop - Boost" note "Now Set to idle [ Waiting for Apps ]"
        am start -a AxManager.TOAST -e text "No Targeted App detected [ Wait ]"
        [ "$(getprop ro.product.manufacturer)" = "Xiaomi" ] && { c settings put system POWER_PERFORMANCE_MODE_OPEN 0; c settings put system speed_mode 0; c settings put secure speed_mode_enable 0; c settings put secure miui_refresh_rate 60; }
      fi

        for key in $(c settings list global | grep driver | cut -d'=' -f1); do c settings delete global "$key"; done
    fi
  fi

if grep 0- /proc/$$/status;then
  iorenice $$ 7 idle
  renice -n 19 -p $$
  taskset -ap 1 $$
fi

  sleep 10
done &

notif -S bigtext -t "Bnoop - Boost" test "Now Running in Background [ Waiting ]" >/dev/null 2>&1
