#!/system/bin/sh
MODDIR=${0%/*}

FAKE_DIR="$MODDIR/system/storage/emulated/0/Android/data/com.tencent.ig/files/UE4Game/ShadowTrackerExtra/ShadowTrackerExtra/Content"
REAL_DIR="/storage/emulated/0/Android/data/com.tencent.ig/files/UE4Game/ShadowTrackerExtra/ShadowTrackerExtra/Content"

if [ ! -d "$REAL_DIR" ]; then
    exit 0
fi

mkdir -p "$FAKE_DIR"
if [ ! -d "$FAKE_DIR" ]; then
    exit 0
fi

for file in $(ls "$REAL_DIR" 2>/dev/null); do
    if [ -f "$REAL_DIR/$file" ]; then
        echo > "$FAKE_DIR/$file"
    elif [ -d "$REAL_DIR/$file" ]; then
        mkdir -p "$FAKE_DIR/$file"
    fi
done

chmod -R $(stat -c %a "$REAL_DIR") "$FAKE_DIR" 2>/dev/null
chown -R $(stat -c %u:%g "$REAL_DIR") "$FAKE_DIR" 2>/dev/null
touch -r "$REAL_DIR" "$FAKE_DIR" 2>/dev/null

mount -o bind "$FAKE_DIR" "$REAL_DIR" 2>/dev/null
if [ $? -ne 0 ]; then
    exit 0
fi