#!/system/bin/sh
MODDIR=${0%/*}

# Değişkenler
FAKE_PROC="$MODDIR/system/proc/empty"
FAKE_SYS="$MODDIR/system/sys/empty"
FAKE_PROP="$MODDIR/system/prop/local.prop"
REAL_PROC="/proc"
REAL_SYS="/sys"
REAL_PROP="/system/build.prop"

mkdir -p "$FAKE_PROC" "$FAKE_SYS" "$MODDIR/system/prop"
if [ ! -d "$FAKE_PROC" ] || [ ! -d "$FAKE_SYS" ] || [ ! -f "$FAKE_PROP" ]; then
    exit 0
fi

RAND_ID=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | head -c 8)
RAND_SERIAL=$(cat /dev/urandom | tr -dc '0-9' | head -c 12)
RAND_FINGERPRINT="generic/device_$RAND_ID/$(date +%Y%m%d):user/release-keys"

cat > "$FAKE_PROP" << EOF
ro.build.id=$RAND_ID
ro.product.brand=Generic
ro.product.model=Device_$RAND_ID
ro.serialno=$RAND_SERIAL
ro.build.fingerprint=$RAND_FINGERPRINT
EOF

chmod 555 "$FAKE_PROC" "$FAKE_SYS" 2>/dev/null
chmod 644 "$FAKE_PROP" 2>/dev/null
chown root:root "$FAKE_PROC" "$FAKE_SYS" "$FAKE_PROP" 2>/dev/null

if pgrep -f "com.tencent.ig" >/dev/null; then
    mount -o bind "$FAKE_PROC" "$REAL_PROC" 2>/dev/null
    mount -o bind "$FAKE_SYS" "$REAL_SYS" 2>/dev/null
    mount -o bind "$FAKE_PROP" "$REAL_PROP" 2>/dev/null
    if [ $? -ne 0 ]; then
        exit 0
    fi
fi