#!/system/bin/sh
MODDIR=${0%/*}
CNT=$MODDIR/counter.log
WHITE=$MODDIR/white.list
MODULE_CNT=/data/adb/modules
MODID=RescueX

[ -f $CNT ] && N=$(cat $CNT) || N=0
N=$((N+1))
echo $N > $CNT

skip(){ [ -f $WHITE ] && grep -q "^$1$" $WHITE; }

if [ $N -eq 3 ]; then
  for mod in $(ls $MODULE_CNT); do
    [ "$mod" = "$MODID" ] && continue
    skip $mod && continue
    touch $MODULE_CNT/$mod/disable
  done
  RESCUE=$(cat $MODDIR/rescue_cnt 2>/dev/null || echo 0)
  RESCUE=$((RESCUE+1))
  echo $RESCUE > $MODDIR/rescue_cnt
  sed -i "/^description=/c description=已救砖 $RESCUE 次" $MODDIR/module.prop
  rm -f $CNT
  reboot
fi

if [ $N -ge 4 ]; then
  rm -f /data/system/users/0/package-restrictions.xml
  rm -f $CNT
  reboot
fi