SKIPUNZIP=0
check_magisk_version() {
	ui_print "- Magisk version: $MAGISK_VER_CODE"
	ui_print "- Module version: $(grep_prop version "${TMPDIR}/module.prop")"
	if [ "$MAGISK_VER_CODE" -lt 20400 ]; then
		ui_print "***************************************************"
		ui_print "! 请安装 Magisk v20.4+ (20400+)"
		abort    "***************************************************"
	fi
}
check_required_files() {
	REQUIRED_FILE_LIST="/sys/class/power_supply/battery/status"
	for REQUIRED_FILE in $REQUIRED_FILE_LIST; do
		if [ ! -e $REQUIRED_FILE ]; then
			ui_print "***************************************************"
			ui_print "! $REQUIRED_FILE 文件不存在"
			ui_print "! 请联系模块作者"
			abort    "***************************************************"
		fi
	done
}
extract_bin() {
	if [ "$ARCH" == "arm" ]; then
		cp $MODPATH/bin/armeabi-v7a/ultra_performance $MODPATH
	elif [ "$ARCH" == "arm64" ]; then
		cp $MODPATH/bin/arm64-v8a/ultra_performance $MODPATH
	elif [ "$ARCH" == "x86" ]; then
		cp $MODPATH/bin/x86/ultra_performance $MODPATH
	elif [ "$ARCH" == "x64" ]; then
		cp $MODPATH/bin/x86_64/ultra_performance $MODPATH
	else
		abort "! Unsupported platform: $ARCH"
	fi
	ui_print "- Device platform: $ARCH"
	rm -rf $MODPATH/bin
}
find_trip_point_temp_files() {
	ui_print "***************************************************"
	ui_print "- Trip point temp files:"
	for THERMAL_ZONE in $(ls /sys/class/thermal/thermal_zone*/type); do
		if cat $THERMAL_ZONE | grep -E "cpu|gpu|ddr" >/dev/null; then
			for TRIP_POINT_TEMP in $(ls ${THERMAL_ZONE%/*}/trip_point_*_temp); do
				if [ "$(cat $TRIP_POINT_TEMP)" -lt "111000" ]; then
					ui_print "$TRIP_POINT_TEMP $(cat ${TRIP_POINT_TEMP%/*}/type)"
				fi
			done
		fi
	done
}
remove_sys_perf_config() {
	ui_print "***************************************************"
	for SYSPERFCONFIG in $(ls /system/vendor/etc/perf/perf*.xml /system/vendor/etc/perf/power*.xml  /system/vendor/etc/zperf_* /system/vendor/etc/thermal-engine.conf); do
		[[ ! -d $MODPATH${SYSPERFCONFIG%/*} ]] && mkdir -p $MODPATH${SYSPERFCONFIG%/*}
		ui_print "- Config file:$SYSPERFCONFIG"
		touch $MODPATH$SYSPERFCONFIG
	done
	ui_print "***************************************************"
}
check_required_files
extract_bin
find_trip_point_temp_files
remove_sys_perf_config
check_magisk_version
set_perm_recursive "$MODPATH" 0 0 0755 0644
set_perm_recursive "$MODPATH/*.sh" 0 2000 0755 0755 u:object_r:magisk_file:s0
set_perm_recursive "$MODPATH/ultra_performance" 0 2000 0755 0755 u:object_r:magisk_file:s0
ui_print "***************************************************"
ui_print "- 主程序使用C语言编写，在功耗可接受的前提下，"
ui_print "- 通过修改处理器调度、移除厂商对性能释放限制，"
ui_print "- 以及提高CPU/GPU/DDR温度墙上限等多种方式，"
ui_print "- 让设备的性能释放最大化。"
ui_print "***************************************************"
ui_print "- 部分功能可在模块的 system.prop 文件中开启或关闭！"
ui_print "***************************************************"
