
wait_sys_boot_completed() {
	local i=9
	until [ "$(getprop sys.boot_completed)" == "1" ] || [ $i -le 0 ]; do
		i=$((i-1))
		sleep 9
	done
}
perfboost() {
	for CPU_ONLINE in $(ls /sys/devices/system/cpu/cpu*/online 2>/dev/null); do
		if [ "$(cat $CPU_ONLINE)" == "0" ]; then
			echo "1" > $CPU_ONLINE
		fi
	done
	for CPUFREQ_POLICY_PATH in $(ls -d /sys/devices/system/cpu/cpufreq/policy* 2>/dev/null); do
		if [ -f ${CPUFREQ_POLICY_PATH}/cpuinfo_max_freq ] && [ -f ${CPUFREQ_POLICY_PATH}/scaling_max_freq ]; then
			echo "$(cat ${CPUFREQ_POLICY_PATH}/cpuinfo_max_freq)" > ${CPUFREQ_POLICY_PATH}/scaling_max_freq
		fi
	done
	for THERMAL_ZONE in $(ls /sys/class/thermal/thermal_zone*/type); do
		if cat $THERMAL_ZONE | grep -E "cpu|gpu|ddr" >/dev/null; then
			for TRIP_POINT_TEMP in $(ls ${THERMAL_ZONE%/*}/trip_point_*_temp); do
				fi
			done
		fi
	done
}
wait_sys_boot_completed && perfboost
cd ${0%/*}
./ultra_performance >/dev/null 2>&1 &
if [ -n "$(getprop ro.miui.ui.version.code)" ]; then
	settings put system POWER_SAVE_PRE_HIDE_MODE performance
	settings put secure speed_mode_enable 1
	settings put system speed_mode 1
fi
if [ -e /proc/game_opt/disable_cpufreq_limit ] && [ "$(cat /proc/game_opt/disable_cpufreq_limit)" == "0" ]; then
	echo "1" > /proc/game_opt/disable_cpufreq_limit
fi
if [ -e /sys/devices/system/cpu/cpufreq/boost ] && [ "$(cat /sys/devices/system/cpu/cpufreq/boost)" == "0" ]; then
	echo "1" > /sys/devices/system/cpu/cpufreq/boost
fi
if [ $(settings get system peak_refresh_rate) -ge 90 ]; then
	[ $(settings get system peak_refresh_rate) -ge $(settings get secure miui_refresh_rate) ] && settings put secure miui_refresh_rate "$(settings get system peak_refresh_rate)"
	[ $(settings get system peak_refresh_rate) -ge $(settings get secure user_refresh_rate) ] && settings put secure user_refresh_rate "$(settings get system peak_refresh_rate)"
fi
set_min_uclamp() {
	local uclamp_file="/dev/cpuctl/$2/cpu.uclamp.min"
	if [[ -f "$uclamp_file" ]]; then
		chmod a+w $uclamp_file
		echo "$1" >$uclamp_file
		chmod a-w $uclamp_file
	fi
}
set_min_uclamp 100 top-app
set_min_uclamp 15 foreground
