#!/system/bin/sh
MODDIR=${0%/*}
TAG="TouchEnhancer-2.0.2"

log -t $TAG "Starting Touch Enhancer service..."

rate=$(dumpsys SurfaceFlinger | grep -m 1 "refreshRate" | awk '{print int($3)}')

if [ -z "$rate" ] || [ "$rate" = "0" ]; then
    rate=$(dumpsys display | grep -m 1 "fps" | awk -F'=' '{print int($2)}')
fi

if [ -z "$rate" ] || [ "$rate" = "0" ]; then
    rate=60
    log -t $TAG "Fallback to 60Hz"
else
    log -t $TAG "Detected refresh rate: ${rate}Hz"
fi

case "$rate" in
    60)  sample=180 ;;
    90)  sample=240 ;;
    120) sample=300 ;;
    144) sample=360 ;;
    *)   sample=200 ;;
esac

resetprop persist.touch.sample_rate "$sample"
resetprop persist.touch.enhancer.version "2.0.2"

log -t $TAG "Applied sample rate: ${sample}Hz"
