#!/system/bin/sh
#
# Touch Enhancer v2.0.2 Uninstaller
# by kirkthatshitt
#
# Restores touch settings and removes module data
#

LOG="/dev/null"

# --- Restore default touch properties ---
if resetprop persist.touch.sample_rate >/dev/null 2>&1; then
  resetprop --delete persist.touch.sample_rate &> $LOG
fi

# --- Disable input boost if module enabled it ---
if [ -f /sys/module/cpu_boost/parameters/input_boost_enabled ]; then
  echo 0 > /sys/module/cpu_boost/parameters/input_boost_enabled 2>/dev/null
fi

# --- Revert enabled input devices ---
for input in /sys/class/input/input*; do
  if [ -w "$input/enabled" ]; then
    echo 0 > "$input/enabled" 2>/dev/null
  fi
done

# --- Clean module folders (Magisk/KSU/APatch safe delete) ---
rm -rf /data/adb/modules/touchenhancer
rm -rf /data/adb/modules_update/touchenhancer
rm -rf /data/