##########################################################################################
#
# Skrip Instalasi ZH-OPTIMASION
#v:1.1
##########################################################################################

# 1. Tampilkan Informasi Modul
ui_print "*******************************"
ui_print " ZH-OPTIMASION: The Trinity"
ui_print " SF + Input + Overlord"
ui_print " Versi: 1.1"
ui_print " Penulis: @Zhetsu_6"
ui_print "*******************************"
ui_print " "

# 2. Pemeriksaan Arsitektur
if [ "$ARCH" != "arm" ] && [ "$ARCH" != "arm64" ]; then
  abort "! Perangkat Anda tidak menggunakan arsitektur arm atau arm64."
fi

# 3. Proses Ekstraksi
ui_print "- Mengekstrak semua Artefak..."
# Ekstrak semua file yang kita butuhkan
unzip -o "$ZIPFILE" 'module.prop' 'post-fs-data.sh' 'uninstall.sh' 'list.txt' 'jni/*' 'system/*' -d $MODPATH >&2

# 4. Siapkan File Zygisk (Logika Asli Anda)
ui_print "- Mempersiapkan Senjata Zygisk..."
mkdir -p $MODPATH/zygisk
if [ "$ARCH" = "arm64" ]; then
  ui_print "- Menyiapkan library SF (64-bit)..."
  mv -f $MODPATH/jni/arm64-v8a/libzygisk.so $MODPATH/zygisk/sf.so
  
  ui_print "- Menyiapkan library Input (64-bit)..."
  mv -f $MODPATH/jni/arm64-v8a/libinputzygisk.so $MODPATH/zygisk/input.so
else
  ui_print "- Menyiapkan library SF (32-bit)..."
  mv -f $MODPATH/jni/armeabi-v7a/libzygisk.so $MODPATH/zygisk/sf.so
  
  ui_print "- Menyiapkan library Input (32-bit)..."
  mv -f $MODPATH/jni/armeabi-v7a/libinputzygisk.so $MODPATH/zygisk/input.so
fi

# 5. Siapkan Quantum Overlord
# Tidak perlu dipindahkan karena sudah diekstrak ke path yang benar (system/bin)
ui_print "- Membangun Takhta untuk Sang Overlord..."

# 6. Pembersihan
ui_print "- Membersihkan file sementara..."
rm -rf $MODPATH/jni

# 7. Atur Perizinan
ui_print "- Memberikan Kekuatan pada Tiga Senjata..."
# Atur izin untuk semua file secara umum
set_perm_recursive $MODPATH 0 0 0755 0644
# Beri izin eksekusi khusus untuk Overlord
set_perm $MODPATH/system/bin/quantum_overlord 0 0 0755

# 8. Pesan Penutup
ui_print " "
ui_print "*******************************"
ui_print " Instalasi Selesai!"
ui_print " Silakan reboot perangkat Anda."
ui_print "*******************************"
