#!/system/bin/sh
#
# ZH-OPTIMASION
# Post-FS Data Script
# Dibuat oleh: @Zhetsu_6
#

# Dapatkan path direktori modul kita
MODDIR=${0%/*}

# =====================================================
# BAGIAN 1
# =====================================================
# Logika ini didasarkan pada nama file yang Anda tentukan
# di 'customize.sh' (`sf_64.so`, `input_64.so`, dll).
#
# Dapatkan arsitektur perangkat dari Magisk
ARCH=$(getprop ro.product.cpu.abi)

if [ "$ARCH" = "arm64-v8a" ]; then
  # Muat library untuk perangkat 64-bit
  "$MODDIR/zygisk/sf_64.so"
  "$MODDIR/zygisk/input_64.so"
else
  # Muat library untuk perangkat 32-bit
  "$MODDIR/zygisk/sf_32.so"
  "$MODDIR/zygisk/input_32.so"
fi

# =====================================================
# BAGIAN 2
# =====================================================
# Daemon ini akan menangani semua optimasi CPU dan prioritas
# secara proaktif, menggantikan kebutuhan skrip 'renice'.
#
# Jalankan daemon di background dan berikan path direktori modul.
nohup $MODDIR/system/bin/quantum_overlord $MODDIR > /dev/null 2>&1 &

# =====================================================
# SELESAI
# =====================================================
# Bagian skrip 'renice' telah dihapus karena fungsinya
# sudah diambil alih oleh 'quantum_overlord' dengan cara
# yang lebih canggih dan efisien. Ini mencegah konflik
# dan menjaga skrip tetap bersih.
