#!/system/bin/sh

MODPATH="/data/adb/modules/auto_game_optimizer"
LOG_FILE="/data/local/tmp/optimizer.log"
GAME_MODE_FILE="/data/local/tmp/game_mode_active"
APPS_LIST="/data/local/tmp/gaming_apps.txt"

setup_log() {
    echo "==========================================" > $LOG_FILE
    echo "XianTian started " >> $LOG_FILE
    echo "Date: $(date)" >> $LOG_FILE
    echo "==========================================" >> $LOG_FILE
}

create_apps_list() {
    cat > $APPS_LIST << 'EOF'
# Auto-detected gaming apps
com.mobile.legends
com.tencent.ig
com.pubg.krmobile
com.dts.freefireth
com.garena.game.codm
com.ea.gp.fifamobile
com.activision.callofduty.shooter
com.miHoYo.GenshinImpact
com.supercell.clashofclans
com.supercell.brawlstars
# Add more below...
EOF
}

enable_performance() {
    echo "[$(date '+%H:%M:%S')] Switching to PERFORMANCE mode" >> $LOG_FILE
    
    for gov in /sys/devices/system/cpu/cpufreq/policy*/scaling_governor; do
        [ -f "$gov" ] && echo "performance" > "$gov" 2>/dev/null
    done
    
    [ -f "/sys/class/kgsl/kgsl-3d0/devfreq/governor" ] && \
        echo "performance" > /sys/class/kgsl/kgsl-3d0/devfreq/governor 2>/dev/null
    
    for mali in /sys/devices/platform/*mali*/devfreq/governor; do
        [ -f "$mali" ] && echo "performance" > "$mali" 2>/dev/null
    done
    
    stop thermal-engine 2>/dev/null
    service call vibrator 1 i32 50 i32 0 2>/dev/null
    
    touch $GAME_MODE_FILE
}

enable_balanced() {
    echo "[$(date '+%H:%M:%S')] Switching to BALANCED mode" >> $LOG_FILE
    
    for gov in /sys/devices/system/cpu/cpufreq/policy*/scaling_governor; do
        [ -f "$gov" ] && {
            if grep -q "schedutil" "$gov"; then
                echo "schedutil" > "$gov" 2>/dev/null
            else
                echo "interactive" > "$gov" 2>/dev/null
            fi
        }
    done
    
    [ -f "/sys/class/kgsl/kgsl-3d0/devfreq/governor" ] && \
        echo "msm-adreno-tz" > /sys/class/kgsl/kgsl-3d0/devfreq/governor 2>/dev/null
 
    for mali in /sys/devices/platform/*mali*/devfreq/governor; do
        [ -f "$mali" ] && echo "simple_ondemand" > "$mali" 2>/dev/null
    done
    
    rm -f $GAME_MODE_FILE 2>/dev/null
}

get_foreground_app() {
    local app=$(dumpsys activity activities 2>/dev/null | \
        grep -E "mResumedActivity|mFocusedActivity" | \
        grep -o "com\.[a-zA-Z0-9._]*" | head -1)
    
    [ -z "$app" ] && app=$(dumpsys window windows 2>/dev/null | \
        grep -E "mCurrentFocus|mFocusedApp" | \
        grep -o "com\.[a-zA-Z0-9._]*" | head -1)
    
    echo "$app"
}

start_game_monitor() {
    local last_app=""
    local current_mode="balanced"
    
    echo "[$(date '+%H:%M:%S')] Game monitor started" >> $LOG_FILE
    
    while true; do
        current_app=$(get_foreground_app)
        
        if [ -n "$current_app" ] && [ "$current_app" != "$last_app" ]; then
            
            is_game=$(grep -i "^$current_app" $APPS_LIST 2>/dev/null)
            
            if [ -n "$is_game" ] && [ "$current_mode" != "performance" ]; then
                enable_performance
                current_mode="performance"
                echo "[$(date '+%H:%M:%S')] Game: $current_app" >> $LOG_FILE
                
            elif [ -z "$is_game" ] && [ "$current_mode" != "balanced" ]; then
                enable_balanced
                current_mode="balanced"
                echo "[$(date '+%H:%M:%S')] App: $current_app" >> $LOG_FILE
            fi
            
            last_app="$current_app"
        fi
        
        sleep 3  
    done
}

main() {
    while [ "$(getprop sys.boot_completed)" != "1" ]; do
        sleep 3
    done
    sleep 15
    
    setup_log
    
    [ ! -f "$APPS_LIST" ] && create_apps_list
   
    enable_balanced
    
    echo "[$(date '+%H:%M:%S')] Starting game monitor daemon..." >> $LOG_FILE
    
    start_game_monitor
}

main &