#!/system/bin/sh

MODPATH="/data/adb/modules/XianTian_pro"
GAME_MODE_FILE="/data/local/tmp/xiantian_pro_active"
APPS_LIST="/data/local/tmp/xiantian_games.txt"

if [ ! -f "$APPS_LIST" ]; then
    cat > $APPS_LIST << 'EOF'
com.mobile.legends
com.mobile.legends.bb
com.tencent.ig
com.pubg.krmobile
com.dts.freefireth
com.garena.game.codm
com.ea.gp.fifamobile
com.activision.callofduty.shooter
com.miHoYo.GenshinImpact
com.supercell.clashofclans
com.supercell.brawlstars
EOF
fi

enable_performance() {
    for gov in /sys/devices/system/cpu/cpufreq/policy*/scaling_governor; do
        [ -f "$gov" ] && echo "performance" > "$gov" 2>/dev/null
    done

    [ -f "/sys/class/kgsl/kgsl-3d0/devfreq/governor" ] && \
        echo "performance" > /sys/class/kgsl/kgsl-3d0/devfreq/governor 2>/dev/null

    for mali in /sys/devices/platform/*mali*/devfreq/governor; do
        [ -f "$mali" ] && echo "performance" > "$mali" 2>/dev/null
    done

    stop thermal-engine 2>/dev/null
    touch $GAME_MODE_FILE
}

enable_balanced() {
    for gov in /sys/devices/system/cpu/cpufreq/policy*/scaling_governor; do
        [ -f "$gov" ] && {
            if grep -q "schedutil" "$gov"; then
                echo "schedutil" > "$gov" 2>/dev/null
            else
                echo "interactive" > "$gov" 2>/dev/null
            fi
        }
    done

    [ -f "/sys/class/kgsl/kgsl-3d0/devfreq/governor" ] && \
        echo "msm-adreno-tz" > /sys/class/kgsl/kgsl-3d0/devfreq/governor 2>/dev/null

    rm -f $GAME_MODE_FILE 2>/dev/null
}

get_foreground_app() {
    local app=$(dumpsys activity activities 2>/dev/null | \
        grep -E "mResumedActivity|mFocusedActivity" | \
        grep -o "com\.[a-zA-Z0-9._-]*" | head -1)

    [ -z "$app" ] && app=$(dumpsys window windows 2>/dev/null | \
        grep -E "mCurrentFocus|mFocusedApp" | \
        grep -o "com\.[a-zA-Z0-9._-]*" | head -1)

    echo "$app"
}

start_monitor() {
    local last_app=""
    local current_mode="balanced"

    while true; do
        current_app=$(get_foreground_app)

        if [ -n "$current_app" ] && [ "$current_app" != "$last_app" ]; then
            is_game=$(grep -i "^$current_app$" $APPS_LIST 2>/dev/null)

            if [ -n "$is_game" ] && [ "$current_mode" != "performance" ]; then
                enable_performance
                current_mode="performance"
            elif [ -z "$is_game" ] && [ "$current_mode" != "balanced" ]; then
                enable_balanced
                current_mode="balanced"
            fi

            last_app="$current_app"
        fi

        sleep 3
    done
}

while [ "$(getprop sys.boot_completed)" != "1" ]; do
    sleep 3
done
sleep 15

enable_balanced
start_monitor &