#!/system/bin/sh
MODDIR=${0%/*}

until [ "$(getprop sys.boot_completed)" -eq 1 ]; do sleep 5; done

echo 60 > /proc/sys/vm/swappiness
echo 100 > /proc/sys/vm/vfs_cache_pressure
setprop ro.lmk.kill_heaviest_task true
setprop ro.lmk.enhance_batch_kill true

for p in /sys/devices/system/cpu/cpufreq/policy*; do
    [ -f "$p/scaling_governor" ] && echo "schedutil" > "$p/scaling_governor"
    [ -f "$p/schedutil/rate_limit_us" ] && echo 500 > "$p/schedutil/rate_limit_us"
done

for queue in /sys/block/*/queue; do
    echo 256 > "$queue/read_ahead_kb"
    echo 0 > "$queue/add_random"
    echo 0 > "$queue/iostats"
done
fstrim -v /data
fstrim -v /cache

sysctl -w net.ipv4.tcp_congestion_control=bbr 2>/dev/null
sysctl -w net.ipv4.tcp_fastopen=3
echo 1 > /proc/sys/net/ipv4/tcp_low_latency

cmd deviceidle force-idle deep
