#!/system/bin/sh
until [ "$(getprop sys.boot_completed)" = "1" ]; do
    sleep 5
done

settings put system touch_pressure_scale 0.001
settings put global touch_response_time 0
settings put user view_scroll_friction 0.001
settings put global window_animation_scale 0.5
settings put global transition_animation_scale 0.5
settings put global animator_duration_scale 0.5
setprop net.dns1 1.1.1.1
setprop net.dns2 1.0.0.1
settings put global wifi_scan_always_enabled 0
echo "bbr" > /proc/sys/net/ipv4/tcp_congestion_control
setprop debug.hwui.renderer skiavk
setprop debug.egl.hw 1
setprop debug.performance.tuning 1
setprop ro.config.low_ram false

for i in /sys/block/*/queue/read_ahead_kb; do echo 512 > "$i"; done
for i in /sys/block/*/queue/scheduler; do echo "noop" > "$i"; done

echo "18432,23040,27648,32256,55296,80640" > /sys/module/lowmemorykiller/parameters/minfree
echo "100" > /proc/sys/vm/swappiness
setprop debug.atrace.tags.enableflags 0
setprop pinner.enable true

find /data -name "*.db" -type f -exec sqlite3 {} "VACUUM;" \; 2>/dev/null

exit 0
