KronosIOLaunch
 
by: Susanos
 
【English Version】
 
Feature Overview
 
Resolve launcher boot lag and stuttering issues on rooted Android devices
 
Core Features
 
- Prioritize storage I/O resources for launcher apps during device boot

- Auto-select optimal optimization scheme (Priority: Cgroup v2 → Cgroup v1 → memcg → ionice)

- Zero system residue after installation, no extra storage occupation
 
Supported Devices (Officially Tested & Verified)
 
Only fully tested devices are listed, no guarantees for unlisted models
 
- Google Pixel: 8 Pro, 9 Pro (Android 14/15, supports both Magisk & KernelSU)

- Samsung Galaxy: S25 Ultra (One UI 6.0+, Magisk only)

- Xiaomi/Redmi: Redmi K50 Ultra (Snapdragon 8+ Gen1, Magisk only)

- OnePlus: 12 (C15, Android 14, Magisk only)
 
Under Compatibility Testing
 
These models perform well in initial tests, full compatibility is under verification
 
- Nothing Phone 2, Sony Xperia 1 VI, Realme GT 5 Pro, OPPO Find X7 Ultra
 
General Compatibility Notes (No Official Guarantee)
 
- System Version: Android 10 (API29) — Android 16 (API37)

- Root Solution: Magisk (Recommended), KernelSU (Verified on Pixel/OnePlus models; limited support for Xiaomi Dimensity devices)

- Important Note: Xiaomi Dimensity devices only support Magisk (KernelSU/APATCH untested, no guarantee of functionality)
 
Installation Steps
 
1.Package module files into a zip →  io_arbiter-v1.0.1.zip

2.hnstall via Magisk/KernelSU Manager, then reboot your device

3.Android 12+ devices will automatically enable Cgroup v2 IO controller permanently (persists after reboot)
 
Tips
 
- If the module fails to detect niche launchers, add the launcher package name to the pidof line in service.sh

- Uninstall directly via Root Manager with zero residue

- Pre-deployment Test: For unlisted models, run the check_compatibility.sh script first to confirm Cgroup/ionice support before installation
 

 
【中文版本】
 
功能简介
 
解决已Root安卓手机的桌面开机加载慢、卡顿问题
 
核心功能
 
- 开机时优先分配桌面程序的存储读写资源

- 自动选择最优优化方案（优先级：Cgroup v2 → Cgroup v1 → memcg → ionice）

- 运行后无任何系统残留，不占用额外空间
 
支持机型（官方实测验证通过）
 
只列经过完整测试的机型，在此不做任何承诺
 
- 谷歌 Pixel：8 Pro、9 Pro（安卓14/15系统，Magisk/KernelSU 均支持）

- 三星 Galaxy：S25 Ultra（One UI 6.0及以上系统，仅支持 Magisk）

- 小米/红米：红米 K50 Ultra（骁龙8+ Gen1芯片，仅支持 Magisk）

- 一加：12（C15系统，安卓14，仅支持 Magisk）
 
兼容测试中（正在验证）
 
这些机型初步测试表现良好，但完整兼容性还在验证
 
- Nothing Phone 2、索尼 Xperia 1 VI、真我 GT 5 Pro、OPPO Find X7 Ultra
 
通用兼容说明（无官方保障）
 
- 系统版本：安卓10（API29）—— 安卓16（API37）

- Root方案：Magisk（首选）、KernelSU（在Pixel/一加机型上验证通过；小米天玑芯片机型支持有限）

- 重要提示：小米天玑芯片机型仅支持 Magisk（KernelSU/APATCH 未验证，不保证能用）
 
使用步骤
 
1.把模块文件打包成压缩包 →  io_arbiter-v1.0.1.zip

2.在Magisk/KernelSU里安装，然后重启手机

3.安卓12及以上设备会自动永久开启Cgroup v2 io控制器（重启后依然生效）
 
温馨提示
 
- 若模块检测不到小众桌面程序，把桌面包名添加到 service.sh 里的 pidof 那一行就行

- 直接在Root管理工具里卸载，无任何残留

- 部署前先测试：未列出的机型，先运行 check_compatibility.sh 脚本，确认设备支持Cgroup/ionice再安装