#!/system/bin/sh
echo "=== KronosIOLaunch ==="
echo "Android SDK: $(getprop ro.build.version.sdk)"
if [ "$(getprop ro.build.version.sdk)" -lt 29 ]; then
echo "❌ Android version too old (needs 10+)"
exit 1
fi
if [ -f "/data/adb/magisk/busybox" ] || [ -f "/data/adb/kernelsu/bin/busybox" ]; then
echo "✅ Root detected"
else
echo "❌ No root found"
exit 1
fi
echo "=== Cgroup Support Check ==="
if [ -f "/sys/fs/cgroup/cgroup.controllers" ] && grep -q "io" /sys/fs/cgroup/cgroup.controllers; then
echo "✅ Cgroup v2 io controller supported"
elif [ -d "/sys/fs/cgroup/blkio" ]; then
echo "✅ Cgroup v1 blkio supported"
elif [ -d "/sys/fs/cgroup/memory" ]; then
echo "✅ memcg supported"
else
echo "⚠️  No Cgroup support, using ionice fallback"
fi
launcher_pid=$(dumpsys window | grep mCurrentFocus | awk '{print $NF}' | xargs pidof)
[ -z "$launcher_pid" ] && launcher_pid=$(pidof com.android.launcher3)
if [ -n "$launcher_pid" ]; then
echo "✅ Launcher PID found: $launcher_pid"
else
echo "⚠️  Launcher PID not found (add package name to service.sh pidof line)"
fi
echo "=== Check Complete ==="