#!/system/bin/sh
until [ "$(getprop sys.boot_completed)" = "1" ]; do
sleep 1
done
launcher_pid=$(dumpsys window | grep mCurrentFocus | awk '{print $NF}' | xargs pidof)
[ -z "$launcher_pid" ] && launcher_pid=$(pidof com.android.launcher3)
[ -z "$launcher_pid" ] && launcher_pid=$(pidof org.lineageos.lineageparts)
[ -z "$launcher_pid" ] && exit 1
mode=$(getprop persist.ioarbiter.mode)
if [ "$mode" = "cgroup2" ]; then
echo "$launcher_pid" > /sys/fs/cgroup/io.latency/cgroup.procs
elif [ "$mode" = "blkio" ]; then
echo "$launcher_pid" > /sys/fs/cgroup/blkio/cg_launcher_high/cgroup.procs
echo 500 > /sys/fs/cgroup/blkio/cg_launcher_high/blkio.weight
elif [ "$mode" = "memcg" ]; then
echo "$launcher_pid" > /sys/fs/cgroup/memory/apps/my_launchercg/cgroup.procs
echo 100000 > /sys/fs/cgroup/memory/apps/my_launchercg/memory.limit_in_bytes
else
ionice -c 1 -n 0 -p "$launcher_pid"
fi
timeout=30
while [ $timeout -gt 0 ]; do
current_focus=$(dumpsys window | grep mCurrentFocus | awk '{print $NF}')
cpu_usage=$(top -n 1 -p "$launcher_pid" | grep "$launcher_pid" | awk '{print $9}' | sed 's/%//g')
if [ -n "$current_focus" ] && [ "$(echo "$cpu_usage < 5" | bc)" -eq 1 ]; then
break
fi
sleep 1
timeout=$((timeout-1))
done
if [ "$mode" = "cgroup2" ]; then
echo "$launcher_pid" > /sys/fs/cgroup/cgroup.procs
elif [ "$mode" = "blkio" ]; then
echo "$launcher_pid" > /sys/fs/cgroup/cgroup.procs
rmdir /sys/fs/cgroup/blkio/cg_launcher_high 2>/dev/null
elif [ "$mode" = "memcg" ]; then
echo "$launcher_pid" > /sys/fs/cgroup/cgroup.procs
rmdir /sys/fs/cgroup/memory/apps/my_launchercg 2>/dev/null
fi
exit 0