#!/system/bin/sh
# --- MTK DYNAMIC THERMAL GUARDIAN + GOVERNOR SYNC ---

TARGET_TEMP_FILE="/sys/class/power_supply/battery/temp"
LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"
CPU_SYS="/sys/devices/system/cpu"

log_msg() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" | tee -a "$LOG_FILE"
}

get_batt_temp() {
    # Returns temp in Celsius (assuming input is in milli-Celsius / 10)
    [ -f "$TARGET_TEMP_FILE" ] && echo $(( $(cat "$TARGET_TEMP_FILE") / 10 )) || echo 0
}

# 1. SET GOVERNOR POLICY
# This ensures all cores are using 'schedutil' before scaling limits
log_msg "INITIALIZING: Setting all CPU policies to schedutil"
for policy in "$CPU_SYS"/cpufreq/policy*; do
    if [ -f "$policy/scaling_governor" ]; then
        echo "schedutil" > "$policy/scaling_governor"
    fi
done

# 2. READ TEMPERATURE
temp=$(get_batt_temp)

# 3. DEFINE SCALING RATIO
case $temp in
    36) freq_scale=100 ;;
    37) freq_scale=95  ;;
    38) freq_scale=90  ;;
    39) freq_scale=85  ;;
    40) freq_scale=80  ;;
    41) freq_scale=75  ;;
    42) freq_scale=70  ;;
    43) freq_scale=65  ;;
    44) freq_scale=60  ;;
    45) freq_scale=55  ;;
    46) freq_scale=50  ;;
    47) freq_scale=45  ;;
    48) freq_scale=40  ;;
    49) freq_scale=35  ;;
    50) freq_scale=30  ;;
    *)  [ "$temp" -gt 50 ] && freq_scale=30 || freq_scale=100 ;;
esac

log_msg "THERMAL_CHECK: Temp=${temp}C | Action: Scaling Max Freq to ${freq_scale}%"

# 4. APPLY FREQUENCY LIMITS
for cpu_path in "$CPU_SYS"/cpu*/cpufreq; do
    if [ -f "$cpu_path/scaling_max_freq" ]; then
        # Read the hardware's absolute max frequency
        max_hardware_freq=$(cat "$cpu_path/cpuinfo_max_freq")
        # Calculate new limit based on scale
        new_limit=$(( max_hardware_freq * freq_scale / 100 ))
        echo "$new_limit" > "$cpu_path/scaling_max_freq"
    fi
done
