#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"

log_msg() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" | tee -a "$LOG_FILE"
}

# Organized SurfaceFlinger + VSync Optimizer

# 1. Find the main Process ID
SF_PID=$(pidof surfaceflinger)

if [ -z "$SF_PID" ]; then
    log_msg "SurfaceFlinger not running."
    exit 1
fi

# 2. Optimize Main Process
# Set highest CPU priority (-20)
renice -n -20 -p "$SF_PID"

# Move main process to top-app cpuset
echo "$SF_PID" > /dev/cpuset/top-app/tasks 2>/dev/null

# Make it unkillable by Low Memory Killer
if [ -f "/proc/$SF_PID/oom_score_adj" ]; then
    echo -1000 > "/proc/$SF_PID/oom_score_adj"
fi

# 3. Optimize Individual Threads (VSync, DispSync, and Render)
# We loop once for efficiency
for thread_path in /proc/$SF_PID/task/*; do
    TID=${thread_path##*/}
    TNAME=$(cat "$thread_path/comm" 2>/dev/null)

    # Move EVERY thread to the top-app cpuset (Big Cores)
    echo "$TID" > /dev/cpuset/top-app/tasks 2>/dev/null
    
    # Apply specialized priority to VSync and App-related threads
    if echo "$TNAME" | grep -iqE "vsync|disp_sync|app|render"; then
        renice -n -20 -p "$TID" 2>/dev/null
        ionice -c 1 -n 0 -p "$TID" 2>/dev/null
    fi
done

log_msg "SurfaceFlinger optimization applied successfully."
