#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"

log_msg() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" | tee -a "$LOG_FILE"
}

# 1. Find the PID that is currently in the 'top-app' cpuset
# This is the most accurate way to find the active app without dumpsys
for pid in /proc/[0-9]*; do
    if grep -q "top-app" "$pid/cpuset" 2>/dev/null; then
        # Exclude SurfaceFlinger and SystemUI so we only get the actual App
        PNAME=$(cat "$pid/cmdline" | tr '\0' ' ')
        case "$PNAME" in
            *surfaceflinger*|*systemui*|*com.android.*) continue ;;
        esac
        
        FPID=${pid##*/}
        break
    fi
done

if [ -z "$FPID" ]; then
    log_msg "Foreground app not found in top-app cpuset."
    exit 1
fi

log_msg "Optimize App PID: $FPID"

# Make it unkillable by Low Memory Killer
if [ -f "/proc/$FPID/oom_score_adj" ]; then
    echo -1000 > "/proc/$FPID/oom_score_adj"
fi

# 2. Apply renice and ionice
renice -n -20 -p "$FPID"
ionice -c 1 -n 0 -p "$FPID" 2>/dev/null

# 3. Apply to all threads of that app
for tid in /proc/$FPID/task/*; do
    TID=${tid##*/}
    renice -n -20 -p "$TID" 2>/dev/null
    echo "$TID" > /dev/cpuset/top-app/tasks 2>/dev/null
done
