#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"

log_msg() {
    # Removed 'tee' to save CPU cycles; direct append is faster
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" >> "$LOG_FILE"
}

#Activating developer options first
su -c settings put global development_settings_enabled 1

log_msg "⚠️Developer options enabled essentials for Gaming props"

sleep 2

# 1. Apply Properties Immediately (Instant)
setprop debug.hwui.render_ahead 1
setprop persist.sys.miravision.vivid.mode 3
setprop persist.sys.force_vivid 1
setprop persist.sys.framepredict.enable true
setprop debug.sf.latch_unsignaled true
setprop debug.sf.latch_unsignaled 1
setprop debug.cpurendering true
setprop debug.egl.force_msaa true
setprop persist.sys.ui.hw true
setprop persist.sys.use_dithering 1
setprop debug.sf.early_phase_offset_ns 5000000
setprop debug.sf.early_gl_phase_offset_ns 3000000
setprop debug.sf.high_fps_early_phase_offset_ns 5000000
setprop debug.sf.high_fps_early_gl_phase_offset_ns 3000000

log_msg "🚀 GAMING MODE: Props applied instantly"
# 2. Async Service Call
# We wrap the heavy 'service call' in ( ) & so it runs in the background.
# This allows the main engine to continue managing the CPU/GPU immediately.

    # No need for a loop or 5-second sleep.
    # If the engine is running, SurfaceFlinger is already active.
    service call SurfaceFlinger 1008 i32 1 >/dev/null 2>&1
    log_msg "🎮 GAMING PROPS: SF 1008 Applied"

