#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"

log_msg() {
    # Removed 'tee' to save CPU cycles; direct append is faster
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" >> "$LOG_FILE"
}

setprop debug.graphics.game_default_frame_rate.disabled false
log_msg "Enable 60fps limiter for games"
# --- PERFORMANCE MODES ---

get_thermal_percent() {
    # Path for Battery Temp (Standard Android)
    local RAW=$(cat /sys/class/power_supply/battery/temp 2>/dev/null)
    [ -z "$RAW" ] && RAW=$(cat /sys/class/thermal/thermal_zone0/temp 2>/dev/null)
    local T=$((RAW / 10)) # Convert 400 to 40

    if [ "$T" -ge 43 ]; then echo 70
    elif [ "$T" -eq 42 ]; then echo 75
    elif [ "$T" -eq 41 ]; then echo 80
    elif [ "$T" -eq 40 ]; then echo 85
    elif [ "$T" -eq 39 ]; then echo 90
    elif [ "$T" -eq 38 ]; then echo 95
    else echo 100
    fi
}

# 1. Calculate Target Percent based on Temp
    local PERCENT=$(get_thermal_percent)
    log_msg "⚡ [GAMING] Temp Check: Applying ${PERCENT}% Lock..."
    
    # 3. APPLY FREQUENCY CAP
    for policy in /sys/devices/system/cpu/cpufreq/policy*; do
        echo "userspace" > "$policy/scaling_governor" 2>/dev/null
        MAX_VAL=$(cat "$policy/cpuinfo_max_freq")
        
        # MATH: Calculate frequency based on temperature %
        TARGET=$((MAX_VAL * PERCENT / 100))
        
        echo "$TARGET" > "$policy/scaling_min_freq"
        echo "$TARGET" > "$policy/scaling_max_freq"
        echo "$TARGET" > "$policy/scaling_setspeed" 2>/dev/null
        echo "schedutil" > "$policy/scaling_governor"
    done