#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

# 1. Switch all CPU cores to the Performance Governor
for cpu in /sys/devices/system/cpu/cpu[0-9]*; do
    echo "performance" > "$cpu/cpufreq/scaling_governor"
done

# 2. Sync min and max frequencies to the hardware maximum
for cpu in /sys/devices/system/cpu/cpu[0-9]*; do
    # Read the absolute maximum the hardware supports
    MAX_FREQ=$(cat "$cpu/cpufreq/cpuinfo_max_freq")
    
    # Apply it to both the current min and max limits
    echo "$MAX_FREQ" > "$cpu/cpufreq/scaling_min_freq"
    echo "$MAX_FREQ" > "$cpu/cpufreq/scaling_max_freq"
done

echo "Performance lock applied: All cores set to maximum frequency."
