#!/system/bin/sh
# --- Master Performance Script ---

su -c '
# --- Resource Limits ---
echo 16384 > /proc/sys/user/max_user_namespaces
echo 1024 > /proc/sys/user/max_net_namespaces
echo 1024 > /proc/sys/user/max_inotify_instances
echo 100000 > /proc/sys/user/max_inotify_watches

# --- Kernel & Stability ---
echo 512000 > /proc/sys/kernel/threads-max
echo 0 > /proc/sys/kernel/printk_devkmsg
echo 5 > /proc/sys/kernel/panic
echo 10 > /proc/sys/fs/lease-break-time

# --- Storage I/O (The "Instant Load" Tweaks) ---
for i in /sys/block/sd*/queue/read_ahead_kb /sys/block/mmc*/queue/read_ahead_kb; do
    [ -e "$i" ] && echo "2048" > "$i"
done

# Disable I/O Stats to save CPU overhead
for i in /sys/block/sd*/queue/iostats; do
    [ -e "$i" ] && echo "0" > "$i"
done

# Set Scheduler (Handles deadline, mq-deadline, or noop)
for i in /sys/block/sd*/queue/scheduler; do
    if grep -q "mq-deadline" "$i"; then
        echo "mq-deadline" > "$i"
    elif grep -q "deadline" "$i"; then
        echo "deadline" > "$i"
    else
        echo "noop" > "$i"
    fi
done

echo "--- Tweaks Applied Successfully ---"
'
