#!/system/bin/sh

LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"
RAM_THRESHOLD=50

log_msg() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" | tee -a "$LOG_FILE"
}
# 1. Get ONLY packages that are currently running
# 'ps' lists processes, 'grep' finds the package names
RUNNING_PKGS=$(ps -A | awk '{print $9}' | grep "\." | sort -u)

# 2. Loop through and trim only those
for pkg in $RUNNING_PKGS; do
    # Skip system-critical processes that might cause crashes if forced to trim
    if [[ "$pkg" == *"com.android.systemui"* || "$pkg" == *"com.android.launcher"* ]]; then
        continue
    fi

    log_msg "Trimming Running App: $pkg"
    # Use RUNNING_CRITICAL for apps currently in use/foreground
    # Use COMPLETE for apps that might be in the background
    am send-trim-memory "$pkg" RUNNING_CRITICAL 2>/dev/null
done
