#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"
EXCLUDE_FILE="/sdcard/exclude_apps.txt"

# Create log file if missing
[ -f "$LOG_FILE" ] || touch "$LOG_FILE"

log_msg() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" >> "$LOG_FILE"
}

#Kill Background Apps with "Self-Preservation" Shield
for pkg in $(pm list packages -3 | cut -d: -f2); do
    
    # 🛡️ THE TRIPLE SYSTEM SHIELD
    if [[ "$pkg" == com.android* ]] || [[ "$pkg" == android* ]] || [[ "$pkg" == com.mediatek* ]]; then
        continue
        
    # 🛡️ THE SCRIPT & SHELL SHIELD (Prevents script suicide)
    elif [[ "$pkg" == *shell* ]] || [[ "$pkg" == *terminal* ]] || [[ "$pkg" == *termux* ]] || [[ "$pkg" == *logcat* ]]; then
        continue

    # 🛡️ THE USER SHIELD (Your excluded list)
    elif [ -f "$EXCLUDE_FILE" ] && grep -q "$pkg" "$EXCLUDE_FILE"; then
        log_msg "🛡️ User-Protected: $pkg"
        continue
        
    else
        # Force-stop only non-essential apps
        am force-stop "$pkg"
        log_msg "❌ Force-stopped: $pkg"
    fi
done

log_msg "🏁 Powersaving mode complete. Script is still alive."
sync
