#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

# --- MTK AI ENGINE: NON-DESTRUCTIVE PURGE ---

LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"

# Create log file if missing
[ -f "$LOG_FILE" ] || touch "$LOG_FILE"

log_msg() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" >> "$LOG_FILE"
}

log_msg "🚀 MTK_AI_Engine: Starting powersaving mode..."

# 1. Apply Powersave Governor (Your core logic)
for policy in /sys/devices/system/cpu/cpufreq/policy*; do
    if [ -f "$policy/scaling_governor" ]; then
        echo "powersave" | su -c "tee $policy/scaling_governor" > /dev/null
    fi
done
log_msg "🔋 CPU clusters locked to powersave."
