#!/system/bin/sh

# Define the target directory
TARGET_DIR="/sdcard/MTK_AI_Engine"

# List of files to restore (without the .exec suffix)
FILES=("enable_touch1" "enable_touch2")

for FILE_NAME in "${FILES[@]}"; do
    # Define the path of the file as it currently exists with .exec
    FILE_WITH_EXT="$TARGET_DIR/$FILE_NAME.exec"
    # Define the target path (original name)
    ORIGINAL_PATH="$TARGET_DIR/$FILE_NAME"

    # Check if the .exec file exists
    if [ -f "$FILE_WITH_EXT" ]; then
        echo "Restoring: $FILE_NAME.exec to $FILE_NAME"
        mv "$FILE_WITH_EXT" "$ORIGINAL_PATH"
    else
        echo "Skipping: $FILE_NAME.exec not found."
    fi
done