#!/system/bin/sh

LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"
MY_PID=$$  # Gets the PID of this current script
echo "--- Smart Sweep: $(date '+%H:%M:%S') ---" >> "$LOG_FILE"

# 1. Get boosted TIDs and convert to unique PIDs
BOOSTED_PIDS=$(cat /dev/cpuset/top-app/tasks | xargs -n 1 ps -o PID= -p 2>/dev/null | sort -u)

if [ -z "$BOOSTED_PIDS" ]; then
    echo "[LOG] top-app is already clean." >> "$LOG_FILE"
    exit 0
fi

for PID in $BOOSTED_PIDS; do
    # --- SELF PROTECTION LOGIC ---
    # 1. Skip if the PID matches this script's PID
    if [ "$PID" -eq "$MY_PID" ]; then
        continue
    fi

    # 2. Get process name and full command line
    PNAME=$(cat /proc/$PID/cmdline 2>/dev/null | tr '\0' ' ')
    
    # 3. Skip if the process belongs to your module or system core
    case "$PNAME" in
        *MTK_AI*|*magisk*|*sh*|*surfaceflinger*|*systemui*|*system_server*|*composer*)
            echo "[LOG] Protecting: $PNAME" >> "$LOG_FILE"
            continue
            ;;
        "") continue ;;
    esac

    # --- RESETTING LOGIC ---
    echo "[LOG] Resetting App: $PNAME (PID: $PID)" >> "$LOG_FILE"
    
    echo 0 > "/proc/$PID/oom_score_adj" 2>/dev/null
    renice -n 0 -p "$PID" 2>/dev/null

    # Move all threads of this app to background
    for TID in $(ls /proc/$PID/task/); do
        echo "$TID" > /dev/cpuset/system-background/tasks 2>/dev/null
    done
done

echo "[LOG] Sweep Complete." >> "$LOG_FILE"