#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"

log_msg() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" | tee -a "$LOG_FILE"
    [ "$(wc -l < $LOG_FILE)" -gt 200 ] &&
        tail -n 200 "$LOG_FILE" > "$LOG_FILE.tmp" &&
        mv "$LOG_FILE.tmp" "$LOG_FILE"
}

log_msg "📱 [DISPLAY] Executing Forced Resolution Reset..."
    
    # We remove the "if" check so it ALWAYS sends the command
    wm size reset
    sleep 0.2
    wm density reset
    
    # Backup: If 'reset' fails, manually set standard 1080p values 
    # (Change 1080x2400/480 to match your phone's real native specs)
    if [ "$(wm size)" != "Physical size: 1080x2400" ]; then
         wm size reset >/dev/null 2>&1
    fi

    RESOLUTION_SCALED="false"