#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

# WEBUI & COMMAND DISPATCHER ---
# If an argument is passed (like "cooler"), run it through the WebUI logic immediately.
if [ -n "$1" ]; then
  WEBUI_SCRIPT="/data/adb/modules/MTK_AI/webroot/cgi-bin/action.sh"
  if [ -x "$WEBUI_SCRIPT" ]; then
    # We export QUERY_STRING so the WebUI script thinks it came from a browser
    export QUERY_STRING="cmd=$1"
    sh "$WEBUI_SCRIPT"
    exit 0
  fi
fi

#!/system/bin/sh

# --- PATHS ---
CFG_DIR="/sdcard/MTK_AI_Engine"
mkdir -p "$CFG_DIR"

# --- KEY DETECTION LOGIC ---
keytest() {
  local event
  while true; do
    event="$(getevent -lqn -c1)"
    if echo "${event}" | grep -q "KEY_VOLUMEUP.*DOWN"; then
      return 0
    elif echo "${event}" | grep -q "KEY_VOLUMEDOWN.*DOWN"; then
      return 1
    fi
  done
}

# --- TOGGLE FUNCTION ---
manage_setting() {
    local FILE="$1"
    local DESC="$2"
    
    echo "> $DESC"
    if [ -f "$CFG_DIR/$FILE" ]; then
        echo "  STATUS: [ ENABLED ]"
    else
        echo "  STATUS: [ DISABLED ]"
    fi
    
    echo "  (VOL+ = ENABLE | VOL- = DISABLE/SKIP)"

    if keytest; then
        if [ ! -f "$CFG_DIR/$FILE" ]; then
            touch "$CFG_DIR/$FILE"
            echo "  Result: NOW ENABLED"
        else
            echo "  Result: ALREADY ENABLED"
        fi
    else
        if [ -f "$CFG_DIR/$FILE" ]; then
            rm -f "$CFG_DIR/$FILE"
            echo "  Result: NOW DISABLED (File Removed)"
        else
            echo "  Result: SKIPPED (Remains Disabled)"
        fi
    fi
    echo "------------------------------------"
}

# --- MENU UI ---
echo "**************************************"
echo "    MEDIATEK AI LIVE MANAGER        "
echo "**************************************"
echo "  VOL+ = Toggle | VOL- = Next Setting "
echo "**************************************"
echo ""

# --- EXISTING FEATURES ---
manage_setting "enable_logcat" "⚠️LOGCAT DETECTION: Automatic Gaming/Non-gaming switching?"
manage_setting "enable_touch1" "⚠️TOUCH1: Boost in touch while powersaving"
manage_setting "enable_touch2" "⚠️TOUCH2: Alternative touch detection (Choose only one!)"
manage_setting "enable_booster" "⚠️TOUCH MODE: 100% CPU Frequencies on touch"
manage_setting "enable_limiter" "⚠️LIMITER: Keep CPU at 30% during inactivity"

echo ""
echo "--- LOGCAT-DEPENDENT TWEAKS ---"
manage_setting "enable_downscale" "720p Downscaling on gaming mode"
manage_setting "enable_disable_thermal" "WARNING: Thermal Bypass (High Heat 🔥)"
manage_setting "enable_gaming_prop" "Enable Gaming Props (4XMSAA/HW Overlays)"
manage_setting "enable_cpu" "Enable Temperature-based CPU Downclocking"
manage_setting "enable_lite_gaming" "Lite Gaming Mode (60fps Limit/Schedutil)"
manage_setting "enable_surfaceflinger" "Optimize Surfaceflinger (Smooth but Hot 🔥)"

echo ""
echo "--- FILE SYSTEM OVERLAYS (NEW) ---"
manage_setting "enable_gameprops_file" "Added gameprops using Redmagic 11 pro+ Snapdragon 8 Gen 5"
manage_setting "enable_gbe_cfg" "Added Game booster Engine to load fast resources?"

echo ""
echo "All changes saved to $CFG_DIR"
echo ""

# --- REBOOT CHECK ---
if [ -f "$CFG_DIR/enable_gameprops_file" ] || [ -f "$CFG_DIR/enable_gbe_cfg" ]; then
    echo "⚠️ NOTICE: You have enabled File Overlays. A REBOOT is required to apply/remove these specific files."
else
    echo "No reboot required. Detection engine updated."
fi
echo ""
