#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

# --- CONFIGURATION ---
GAME_LIST_FILE="/sdcard/game_list.txt"
LOG_FILE="/sdcard/MTK_AI_Engine/MTK_AI_Engine.log"
CURRENT_MODE="NONE"

# External Script Paths
EXTERNAL_CFG="/sdcard/MTK_AI_Engine"
MOD_DIR="/data/adb/modules/MTK_AI"
COOLER_PATH="$MOD_DIR/MTK_AI/AI_MODE/normal_mode/cooler.sh"
DISABLE_THERMAL_PATH="$MOD_DIR/MTK_AI/AI_MODE/gaming_mode/disable_thermal.sh"
MAINTENANCE_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/auto_frequency.sh"
#SCREEN_OFF_PATH="$MOD_DIR/MTK_AI/AI_MODE/normal_mode/powersave.sh"
SCREEN_ON_PATH="$MOD_DIR/MTK_AI/AI_MODE/normal_mode/schedutil.sh"
CPUSET_GAMING_PATH="$MOD_DIR/MTK_AI/AI_MODE/gaming_mode/gaming_cpuset.sh"
CPUSET_NORMAL_PATH="$MOD_DIR/MTK_AI/AI_MODE/normal_mode/normal_cpuset.sh"
RESTORE_DOWNSCALE_PATH="$MOD_DIR/MTK_AI/AI_MODE/normal_mode/restore_downscale.sh"
LOW_DOWNSCALE_PATH="$MOD_DIR/MTK_AI/AI_MODE/gaming_mode/downscale.sh"
NORMAL_PROP_PATH="$MOD_DIR/MTK_AI/AI_MODE/normal_mode/normal_prop.sh"
GAMING_PROP_PATH="$MOD_DIR/MTK_AI/AI_MODE/gaming_mode/gaming_prop.sh"
#AUTOKILL_PATH="$MOD_DIR/MTK_AI/AI_MODE/normal_mode/autokill.sh"
LIMITER_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/cpulimiter.sh"
LITE_GAMING_PATH="$MOD_DIR/MTK_AI/AI_MODE/gaming_mode/lite_gaming.sh"
PERFORMANCE_PATH="$MOD_DIR/MTK_AI/AI_MODE/gaming_mode/performance.sh"
UNLOCK_FPS_PATH="$MOD_DIR/MTK_AI/AI_MODE/gaming_mode/unlockfps.sh"
OPEN_DEV_PATH="$MOD_DIR/MTK_AI/AI_MODE/system_properties/open_developer.sh"
HIDE_DEV_PATH="$MOD_DIR/MTK_AI/AI_MODE/system_properties/hide_developer.sh"
SF_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/surfaceflinger.sh"
APP_OPTIMIZER_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/app_optimizer.sh"
RENAME_PATH="$MOD_DIR/MTK_AI/AI_MODE/gaming_mode/rename.sh"
RESET_NAME_PATH="$MOD_DIR/MTK_AI/AI_MODE/normal_mode/reset_name.sh"

log_msg() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" | tee -a "$LOG_FILE"
    [ "$(wc -l < $LOG_FILE)" -gt 200 ] &&
        tail -n 200 "$LOG_FILE" > "$LOG_FILE.tmp" &&
        mv "$LOG_FILE.tmp" "$LOG_FILE"
}

# --- THE UNIVERSAL EXECUTION WRAPPER ---
# This function fixes the "Path Not Working" issue
run_external_safe() {
    local SCRIPT_PATH="$1"
    
    # 1. Check if the file actually exists first
    if [ ! -f "$SCRIPT_PATH" ]; then
        log_msg "❌ Error: Script not found at $SCRIPT_PATH"
        return 1
    fi

    # 2. Check for running process, but ignore the current shell
    # We use [ $SCRIPT_PATH ] to make grep more specific
    if pgrep -f "$SCRIPT_PATH" | grep -v "$$" > /dev/null; then
        # log_msg "🔁 $SCRIPT_PATH is already running. Skipping..."
        return 1
    else
        # 3. Use nohup or & with su -c for guaranteed execution
        # We use 'sh' specifically to ensure it's treated as a script
        su -c "sh '$SCRIPT_PATH'" >/dev/null 2>&1 &
        return 0
    fi
}

apply_gaming_logic() {
    
    # 2. Downscale check
    if [ -f "$EXTERNAL_CFG/enable_downscale" ] && [ -f "$LOW_DOWNSCALE_PATH" ]; then
        run_external_safe "$LOW_DOWNSCALE_PATH"
    fi
    
    run_external_safe "$PERFORMANCE_PATH"
    run_external_safe "$CPUSET_GAMING_PATH" 
    run_external_safe "$RENAME_PATH"                   
    # 2. Trigger Thermal Script & Gaming props script (Crucial when 100% locked)
    if [ -f "$EXTERNAL_CFG/enable_disable_thermal" ] && [ -f "$DISABLE_THERMAL_PATH" ]; then
        run_external_safe "$DISABLE_THERMAL_PATH"
    fi
    if [ -f "$EXTERNAL_CFG/enable_gaming_prop" ] && [ -f "$GAMING_PROP_PATH" ]; then
        run_external_safe "$GAMING_PROP_PATH"
    fi        
    if [ -f "$EXTERNAL_CFG/enable_highframerate" ] && [ -f "$UNLOCK_FPS_PATH" ]; then       
        run_external_safe "$UNLOCK_FPS_PATH"
    fi
        
    # 3. CPU Core Retention
    for c in /sys/devices/system/cpu/cpu*/core_ctl; do echo 0 > "$c/enable"; done
    
    CURRENT_MODE="GAMING"
    log_msg "✅ All cores locked at 100%."
}

apply_non_gaming_logic() {
    [ "$CURRENT_MODE" = "NORMAL" ] && return
    log_msg "🔋 [MODE] NORMAL: Releasing frequency locks..."

    # Reset CPU to balanced state
    for policy in /sys/devices/system/cpu/cpufreq/policy*; do
        MIN_VAL=$(cat "$policy/cpuinfo_min_freq")
        MAX_VAL=$(cat "$policy/cpuinfo_max_freq")
        
        echo "schedutil" > "$policy/scaling_governor"
        echo "$MIN_VAL" > "$policy/scaling_min_freq"
        echo "$MAX_VAL" > "$policy/scaling_max_freq"
    done

    # Reset GPU
    GPU_PATH=$(ls -d /sys/class/devfreq/*mali* 2>/dev/null | head -n 1)
    [ -n "$GPU_PATH" ] && echo "powersave" > "$GPU_PATH/governor"

    # Maintenance Logic
    run_external_safe "$SCREEN_ON_PATH"     
    run_external_safe "$COOLER_PATH"    
    run_external_safe "$CPUSET_NORMAL_PATH"
    run_external_safe "$RESTORE_DOWNSCALE_PATH"
    run_external_safe "$NORMAL_PROP_PATH"
    run_external_safe "$RESET_NAME_PATH"
            
    su -c am broadcast -a com.coloros.phonemanager.action.CLEAN_UP
    su -c "am broadcast -a com.transsion.phonemaster.action.CLEAN_MEMORY"
    CURRENT_MODE="NORMAL"
}


# --- DETECTION ENGINE ---

log_msg "🚀 Universal Engine: MediaTek | XOS | HiOS | ColorOS | MIUI"

# Set a high priority for this shell process
renice -n -20 -p $$

su -c "logcat -b events -v threadtime" | while read -r line; do
  
    # --- APP FOCUS (Gaming Logic) ---
    if echo "$line" | grep -qE "input_focus|wm_on_resume_called|top_resumed_app_focus|am_on_resume_called|monitor_focus_event|am_resume_activity"; then
        
        # Multi-ROM Package Extraction
        DETECTED_PKG=$(echo "$line" | grep -oE '[a-zA-Z0-9._]+\/[a-zA-Z0-9._]+' | cut -d'/' -f1 | tail -n 1)
        
        if [ -z "$DETECTED_PKG" ]; then
            DETECTED_PKG=$(echo "$line" | sed -n 's/.* \([^/ ]*\)\/[^/ ]*.*/\1/p' | grep -oE '[a-zA-Z0-9._]+' | head -n 1)
        fi

        [ -z "$DETECTED_PKG" ] || ! echo "$DETECTED_PKG" | grep -q "\." && continue

        case "$DETECTED_PKG" in 
            *launcher*|*systemui*|*settings*|*google*|*transsion*) 
                apply_non_gaming_logic
                continue 
                ;; 
        esac

        IS_GAME=false
        [ -f "$GAME_LIST_FILE" ] && grep -q "^$DETECTED_PKG$" "$GAME_LIST_FILE" && IS_GAME=true

        if [ "$IS_GAME" = true ]; then
            # --- START LITE GAMING INTEGRATION ---
            # Apply standard gaming logic first
            apply_gaming_logic
            
            # Check if Lite Gaming is enabled and the path exists
            if [ -f "$EXTERNAL_CFG/enable_lite_gaming" ] && [ -f "$LITE_GAMING_PATH" ]; then
                log_msg "🍃 Lite Gaming triggered for: $DETECTED_PKG"
                run_external_safe "$LITE_GAMING_PATH"
            fi
            # --- END LITE GAMING INTEGRATION ---
        else
            apply_non_gaming_logic
        fi
    fi
done