#!/system/bin/sh
# Magisk post-fs-data script
MODDIR="/data/adb/modules/MTK_AI"
# Using the module ID folder name for the meta path
METAMOD_TARGET="/data/adb/metamodule/mnt/MTK_AI"
CFG_DIR="/sdcard/MTK_AI_Engine"

# Start Web Server
# Use the full path to magisk/ksu busybox to be safe
$MODDIR/busybox httpd -p 8080 -h "$MODDIR/webroot"

# --- THE FIX: WAIT FOR THE MODULE FOLDER ---
timeout=0
while [ ! -d "$METAMOD_TARGET" ] && [ $timeout -lt 10 ]; do
    sleep 1
    timeout=$((timeout + 1))
done

# --- GAMEPROPS LOGIC ---
if [ -f "$CFG_DIR/enable_gameprops_file" ]; then
    cp "$MODDIR/Extras/gameprops_custom.json" "$METAMOD_TARGET/system/etc/gameprops.json"
else
    cp "$MODDIR/Extras/gameprops_stock.json" "$METAMOD_TARGET/system/etc/gameprops.json"
fi

# --- GBE LOGIC ---
if [ -f "$CFG_DIR/enable_gbe_cfg" ]; then
    cp "$MODDIR/Extras/gbe_custom.cfg" "$METAMOD_TARGET/vendor/etc/gbe.cfg"
else
    cp "$MODDIR/Extras/gbe_stock.cfg" "$METAMOD_TARGET/vendor/etc/gbe.cfg"
fi

# Optional: Fix permissions after mounting
chmod 644 "$METAMOD_TARGET/system/etc/gameprops.json"
chmod 644 "$METAMOD_TARGET/vendor/etc/gbe.cfg"
chown 0.0 "$METAMOD_TARGET/system/etc/gameprops.json"
chown 0.0 "$METAMOD_TARGET/vendor/etc/gbe.cfg"