#!/system/bin/sh

MOD_DIR="/data/adb/modules/MTK_AI"
EXTERNAL_CFG="/sdcard/MTK_AI_Engine"
TRIMMING_PATH="$MOD_DIR/MTK_AI/AI_MODE/global_mode/trim_memory.sh"
RAM_CLEANER_PATH="$MOD_DIR/MTK_AI/AI_MODE/global_mode/ram_cleaner.sh"
LOGIC_CPU7_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/cpu7.sh"
LOGIC_CPU6_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/cpu6.sh"
SF_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/surfaceflinger.sh"
RAM_CLEANER_PATH="$MOD_DIR/MTK_AI/AI_MODE/global_mode/ram_cleaner.sh"
RESOURCES_PATH="$MOD_DIR/MTK_AI/AI_MODE/global_mode/resources_tweaks.sh"

# Ensure permissions
chmod +x "$TRIMMING_PATH"
chmod +x "$RAM_CLEANER_PATH"
chmod +x "$LOGIC_CPU6_PATH"
chmod +x "$LOGIC_CPU7_PATH"
chmod +x "$SF_PATH"
chmod +x "$RESOURCES_PATH"

sh "$RESOURCES_PATH"

# Logic for Trim Memory
if [ -f "$EXTERNAL_CFG/enable_trim" ]; then
    pgrep -f "trim_memory.sh" > /dev/null || sh "$TRIMMING_PATH" &
else
    pkill -f "trim_memory.sh"
fi

# Logic for RAM Cleaner
if [ -f "$EXTERNAL_CFG/enable_cleaner" ]; then
    pgrep -f "ram_cleaner.sh" > /dev/null || sh "$RAM_CLEANER_PATH" &
else
    pkill -f "ram_cleaner.sh"
fi

# Logic for CPU6
if [ -f "$EXTERNAL_CFG/enable_cpu6" ]; then
    pgrep -f "cpu6.sh" > /dev/null || sh "$LOGIC_CPU6_PATH" &
else
    pkill -f "cpu6.sh"
fi

# Logic for CPU7
if [ -f "$EXTERNAL_CFG/enable_cpu7" ]; then
    pgrep -f "cpu7.sh" > /dev/null || sh "$LOGIC_CPU7_PATH" &
else
    pkill -f "cpu7.sh"
fi

# Logic for Surfaceflinger
if [ -f "$EXTERNAL_CFG/enable_surfaceflinger" ]; then
    pgrep -f "surfaceflinger.sh" > /dev/null || sh "$SF_PATH" &
else
    pkill -f "surfaceflinger.sh"
fi
