#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

while [ "$(getprop sys.boot_completed)" != "1" ]; do sleep 5; done
MODDIR="/data/adb/modules/MTK_AI"
WEBROOT="$MODDIR/webroot"
EXTERNAL_CFG="/sdcard/MTK_AI_Engine"
TOUCH1="$MODDIR/touch_detection/touch1.sh"
TOUCH2="$MODDIR/touch_detection/touch2.sh"
LOGCAT="$MODDIR/logcat_detection/logcat.sh"
SCRIPT="$MODDIR/script_runner/global.sh"
OVERLAY="$MODDIR/script_runner/overlay.sh"
# Define the path where the ID will be stored
PID_FILE="/data/adb/modules/MTK_AI/engine.pid"

echo $$ > "$PID_FILE"

# Set highest CPU priority
renice -n -20 -p $$

# Prevent Low Memory Killer (LMK) from targeting this process
if [ -f /proc/$$/oom_score_adj ]; then
    echo -1000 > /proc/$$/oom_score_adj
fi

# Move to top-app cpuset to ensure the script isn't throttled
echo $$ > /dev/cpuset/top-app/tasks 2>/dev/null
   
# Give execution permission
chmod -R 755 "$MODDIR"
chown -R root:shell "$MODDIR"
chmod -R 755 "$WEBROOT"
chmod +x "$WEBROOT/webroot/cgi-bin/action.sh"
chown -R root:shell "$WEBROOT"

# Fix permissions only
chmod 755 "$WEBROOT"
chmod 755 "$WEBROOT/webroot/cgi-bin/action.sh"
chmod 755 "$WEBROOT"/webroot/*.html
chmod 755 "$WEBROOT"/webroot/*.css

pkill -f "httpd.*8080"

busybox httpd -p 8080 -h "$MODDIR/webroot" -c /system/bin/sh

sleep 60

# START THE LIVE MONITOR (Runs in background)
(
    while true; do
        # Logic for TOUCH1
        if [ -f "$EXTERNAL_CFG/enable_touch1" ]; then
            pgrep -f "touch1.sh" > /dev/null || sh "$TOUCH1" &
        else
            pkill -f "touch1.sh"
        fi

        # Logic for TOUCH2
        if [ -f "$EXTERNAL_CFG/enable_touch2" ]; then
            pgrep -f "touch2.sh" > /dev/null || sh "$TOUCH2" &
        else
            pkill -f "touch2.sh"
        fi

        # Logic for LOGCAT
        if [ -f "$EXTERNAL_CFG/enable_logcat" ]; then
            pgrep -f "logcat.sh" > /dev/null || sh "$LOGCAT" &
        else
            pkill -f "logcat.sh"
        fi        
        
            pgrep -f "global.sh" > /dev/null || sh "$SCRIPT"

        sleep 60 # Wakes up every 60 seconds to check for changes
    done
) &