#!/system/bin/sh
#!/data/adb/modules/MTK_AI/busybox sh

# --- PATHS ---
MOD_DIR="/data/adb/modules/MTK_AI"
BB="$MOD_DIR/busybox"
EXTERNAL_CFG="/sdcard/MTK_AI_Engine"
MAINTENANCE_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/auto_frequency.sh"
BOOSTER_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/booster.sh"
LIMITER_PATH="$MOD_DIR/MTK_AI/AI_MODE/auto_frequency/cpulimiter.sh"
TIMEOUT=10

# --- 1. UNIVERSAL DETECTION ---
find_touchscreen() {
    for dev in /dev/input/event*; do
        if getevent -p "$dev" | grep -q "0035"; then
            echo "$dev"
            return 0
        fi
    done
}

TOUCH_DEV=$(find_touchscreen)
[ -z "$TOUCH_DEV" ] && exit 1

# --- 2. CLEANUP OLD PROCESSES ---
pkill -f "getevent $TOUCH_DEV"

# --- 3. THE HEARTBEAT (Background) ---
# We pipe getevent directly. Whenever a touch occurs, it writes a timestamp.
# This bypasses the 'timeout' buffering issue.
(
    getevent "$TOUCH_DEV" | while read -r line; do
        # We don't even need to process the text, just update the file
        echo "$("$BB" date +%s)" > /data/local/tmp/touch_ts
    done
) &

run_cmd() {
    [ -f "$1" ] && sh "$1" >/dev/null 2>&1 &
}

# Initial State
echo "$("$BB" date +%s)" > /data/local/tmp/touch_ts
STATE="PERF"

echo "🚀 Universal Engine: Active"
echo "🎯 Monitoring: $TOUCH_DEV"

# --- 4. THE MONITOR LOOP ---
while true; do
    NOW=$("$BB" date +%s)
    LAST_TS=$(cat /data/local/tmp/touch_ts)
    ELAPSED=$((NOW - LAST_TS))

    if [ "$ELAPSED" -ge "$TIMEOUT" ]; then
        if [ "$STATE" = "PERF" ]; then
            STATE="SAVE"
            if [ -f "$EXTERNAL_CFG/enable_limiter" ]; then
                run_cmd "$LIMITER_PATH"
            fi
        fi
    else
        if [ "$STATE" = "SAVE" ]; then
            STATE="PERF"
            run_cmd "$BOOSTER_PATH"
        fi
    fi

    # UI display
    printf "\r[Dev: %s] [Mode: %s] [Idle: %ds]   " "${TOUCH_DEV##*/}" "$STATE" "$ELAPSED"
    
    sleep 1
done
