#!/system/bin/sh

# Magisk Module Installer Script
# Custom QoS and Network Optimization Module
# Created by Technical Mundeer

MODDIR=${0%/*}

# Attractive Banner Function
show_banner() {
  echo "***********************************************"
  echo "*     Custom QoS & Network Optimization       *"
  echo "*              Created by                     *"
  echo "*          TECHNICAL MUNDEER                 *"
  echo "***********************************************"
}

# Log Function
log_print() {
  echo "[INFO] $1"
}

# Display Banner
show_banner

# Start Installation Process
log_print "Starting installation process..."

# Copy module properties
log_print "Setting up module properties..."
cp -f "$MODDIR/module.prop" "$MODDIR/module.prop.bak"

# Apply TTL tweak
log_print "Applying TTL tweaks..."
iptables -t mangle -A POSTROUTING -j TTL --ttl-set 65

# Apply Traffic Control rules for QoS
log_print "Setting up Traffic Control (QoS)..."
tc qdisc add dev rmnet0 root handle 1: htb default 1
tc class add dev rmnet0 parent 1: classid 1:1 htb rate 2mbit ceil 10mbit
tc filter add dev rmnet0 protocol ip parent 1:0 prio 1 u32 match ip dport 30000 0xffff flowid 1:1

# Optimize system network properties
log_print "Optimizing system network properties..."
echo "net.tcp.buffersize.default=4096,87380,256960,4096,16384,256960" >> /data/local/tmp/system.prop
echo "net.tcp.buffersize.wifi=524288,1048576,2097152,524288,1048576,2097152" >> /data/local/tmp/system.prop
echo "net.ipv4.tcp_congestion_control=cubic" >> /data/local/tmp/system.prop

# Set Permissions
log_print "Setting file permissions..."
chmod 644 "$MODDIR/module.prop"
chmod 644 /data/local/tmp/system.prop

# Finish Installation
log_print "***********************************************"
log_print "* Module Installation Completed Successfully! *"
log_print "* Please reboot your device to apply changes. *"
log_print "* Thank you for choosing Technical Mundeer!   *"
log_print "***********************************************"