# UltraOpt — Native Android Optimization Module (Magisk)

**UltraOpt** is a lightweight Magisk module focused on real, measurable optimization of CPU, GPU, memory and idle behavior.
No placebo tweaks, no vendor hacks, no permanent system changes.

All core logic is implemented in native **C++ binaries** to minimize CPU, RAM and battery overhead.

---

## Key Features

### Smart Power & Performance Management
- Automatic CPU governor switching based on screen state
- Optional GPU governor control (if supported by kernel)
- Kernel deep sleep (mem_sleep) control on screen off
- Safe restore on wake and module removal

### Memory & Background Optimization
- RAM flushing and cache cleanup
- Background process optimization
- ART / DEX optimization tool
- System cleanup utilities

---

## Core Components

### ultraopt (Main Binary)
Unified native binary replacing shell scripts.

Supports:
- Interactive menu
- CLI usage

CLI examples:
```
su -c ultraopt -ram
su -c ultraopt -clean
su -c ultraopt -dex
su -c ultraopt -bg
su -c ultraopt -h
```

Menu mode:
```
su -c ultraopt
```

---

### hibernation (Core Daemon)
Native C++ daemon replacing hibernation.sh.

Behavior (100% preserved):
- Screen ON → apply DEFAULT CPU/GPU governors
- Screen OFF → apply SLEEP CPU/GPU governors
- Optional deep sleep via /sys/power/mem_sleep
- Live config reload without reboot
- Logging to hibernation.log

Optimizations vs shell version:
- No fork/exec loops
- Minimal dumpsys usage
- Direct sysfs writes
- Signal-safe shutdown
- Lower CPU wakeups and battery drain

---

## Configuration

Config file:
```
/data/adb/modules/UltrOpt/mod.cfg
```

Supported keys:
```
DEFAULT_GOV=schedutil
SLEEP_GOV=powersave

DEFAULT_GPU_GOV=msm-adreno-tz
SLEEP_GPU_GOV=simple_ondemand

CHECK_INTERVAL=5
ENABLE_KERNEL_SLEEP=1
```

Changes apply instantly, no reboot required.

---

## Logging

Daemon log:
```
/data/adb/modules/UltrOpt/hibernation.log
```

Example:
```
[12:41:03] START PID:1234
[12:41:10] SLEEP
[12:55:42] AWAKE
[13:10:01] STOP
```

---

## Compatibility

- Android: 11 – 16
- Architectures: arm64, arm, x86_64
- Kernels: Any kernel with standard cpufreq / devfreq
- ROMs: Stock, AOSP, custom

---

## Safety & Design Principles

- No permanent system modifications
- No changes to /system or /vendor
- Runtime-only behavior
- Automatic fallback if governor is unavailable
- Safe removal via Magisk

---

## Installation

1. Install module via Magisk
2. Reboot
3. Configure via:
```
su -c ultraopt
```

---

## Uninstallation

- Disable or remove module in Magisk
- Reboot
- System returns to stock behavior

---

## Philosophy

Less scripts. Less hacks. More control.

UltraOpt focuses on clean implementation, not aggressive tweaking.
