#!/system/bin/sh
SKIPMOUNT=false
PROPFILE=true
POSTFSDATA=true
LATESTARTSERVICE=true

print_separator(){ ui_print " "; ui_print "----------------------------------------";}
print_header(){ ui_print " "; ui_print "========================================"; ui_print "       ULTRAOPT v4.00 • Ultimate"; ui_print "       Author: TosikV2 • Magisk"; ui_print "========================================"; ui_print " ";}
print_success(){ ui_print "[✓] $1";}
print_warning(){ ui_print "[!] $1";}
print_error(){ ui_print "[X] $1";}
print_info(){ ui_print "[i] $1";}

print_header
sleep 1

# ================= ПРОВЕРКА ВЕРСИИ ANDROID =================
ui_print "▸ Android Version Check"
print_separator

API=$(getprop ro.build.version.sdk)
ANDROID=$(getprop ro.build.version.release)

ui_print "  Android: $ANDROID (API $API)"

if [ "$API" -le 28 ]; then  # Android 9 (Pie) и ниже
    ui_print " "
    print_error "UNSUPPORTED ANDROID VERSION"
    ui_print " "
    ui_print "This module requires Android 10 (API 29) or higher."
    ui_print "Android 9 and below are not supported."
    ui_print " "
    ui_print "Installation will be aborted."
    abort
elif [ "$API" -eq 29 ]; then  # Android 10
    print_warning "Android 10 detected"
    ui_print " "
    ui_print "Warning: Some features may have issues on Android 10."
    ui_print "Background restrictions might not work correctly."
    ui_print " "
    sleep 2
elif [ "$API" -ge 30 ]; then  # Android 11+
    print_success "Android 11 or higher detected"
    print_success "Full compatibility"
fi

sleep 1
# ================= КОНЕЦ ПРОВЕРКИ =================

ui_print " "
ui_print "▸ System Information"
print_separator
ARCH=$(getprop ro.product.cpu.abi)
DEVICE=$(getprop ro.product.model)
ui_print "  Device: $DEVICE"
ui_print "  Architecture: $ARCH"

sleep 1
ui_print " "
ui_print "▸ CPU Governor Analysis"
print_separator
if [ -f /sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors ]; then
GOVS=$(cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors)
print_success "Available: $GOVS"
GOV_COUNT=$(echo $GOVS | wc -w)
[ "$GOV_COUNT" -gt 5 ] && print_success "Rich governor support ($GOV_COUNT)" || print_warning "Limited governors ($GOV_COUNT)"
echo "$GOVS" | grep -q "powersave" && PS="Available" || PS="Not found"
echo "$GOVS" | grep -q "performance" && PF="Available" || PF="Not found"
echo "$GOVS" | grep -Eq "schedutil|interactive" && BL="Available" || BL="Not found"
print_info "Powersave: $PS"
print_info "Performance: $PF"
print_info "Balanced: $BL"
else print_error "CPU scaling not available"; fi

sleep 1
ui_print " "
ui_print "▸ GPU Analysis"
print_separator
if [ -f /sys/class/kgsl/kgsl-3d0/devfreq/governor ] || [ -f /sys/class/devfreq/*gpu*/governor ] || [ -f /sys/class/devfreq/*mali*/governor ]; then
print_success "GPU governor control available"
else print_warning "GPU governor control not available"; fi

sleep 1
ui_print " "
ui_print "▸ Kernel Capabilities"
print_separator
[ -f /proc/sys/vm/swappiness ] && print_success "Swap control" || print_warning "No swap control"
[ -f /proc/sys/vm/drop_caches ] && print_success "Cache control" || print_warning "Limited cache control"
[ -f /sys/power/mem_sleep ] && print_success "Deep sleep" || print_warning "No deep sleep"
[ -f /proc/sys/net/ipv4/tcp_congestion_control ] && print_success "TCP optimization" || print_warning "Limited TCP control"

sleep 1
ui_print " "
ui_print "▸ Applying Optimizations"
print_separator
print_info "Cleaning system logs..."
rm -rf /data/anr/* /data/tombstones/* /data/system/dropbox/* 2>/dev/null
rm -rf /data/vendor/wlan_logs/* /data/vendor/thermal/*dump* 2>/dev/null
rm -rf /data/misc/logd/* /data/local/tmp/*.log 2>/dev/null
print_success "Logs cleaned"

print_info "Applying kernel tweaks..."
echo "0" > /proc/sys/kernel/panic 2>/dev/null
echo "0" > /proc/sys/vm/panic_on_oom 2>/dev/null
echo "0 0 0 0" > /proc/sys/kernel/printk 2>/dev/null
print_success "Kernel tweaks applied"

sleep 1
ui_print " "
ui_print "========================================"
ui_print "       INSTALLATION COMPLETE"
ui_print "========================================"
ui_print " "

ui_print "Available Commands:"
print_separator
ui_print ""
ui_print "  hibernation    - Smart CPU/GPU governor control (by default it runs in the background)"
ui_print "  ultraopt    - Module configuration"
ui_print ""
ui_print "  Supports: 1) Interactive menu 2) CLI usage"
ui_print ""
ui_print " CLI examples: "
ui_print "su -c ultraopt -ram"
ui_print "su -c ultraopt -clean"
ui_print "su -c ultraopt -dex"
ui_print "su -c ultraopt -bg"
ui_print "su -c ultraopt -h"
sleep 1
ui_print "Configuration:"
ui_print "  /data/adb/modules/UltrOpt/mod.cfg"
ui_print " "
sleep 2
ui_print "Features:"
ui_print "  • Smart governor switching (screen on/off)"
ui_print "  • Aggressive logging reduction"
ui_print "  • Network optimization (TCP, buffers)"
ui_print "  • Kernel parameter tuning"
ui_print "  • GPU optimization (if available)"
ui_print "  • Safe and reversible"
ui_print " "
sleep 1
if [ "$API" -eq 29 ]; then
    ui_print "⚠️  ANDROID 10 WARNING"
    print_separator
    ui_print "Some features may not work correctly:"
    ui_print "  • Background restrictions (appops)"
    ui_print "  • Deep sleep control"
    ui_print "  • Battery optimizations"
    ui_print " "
    ui_print "Consider upgrading to Android 11+ for"
    ui_print "full functionality."
    print_separator
    ui_print " "
fi
sleep 1
ui_print "Reboot required for full effect"
ui_print " "
sleep 1
ui_print "Telegram: @opensourcemagiskmodule"
am start -a android.intent.action.VIEW -d "https://t.me/opensourcemagiskmodule" >/dev/null 2>&1

sleep 3