#!/system/bin/sh

# Disabling telemetry and logging (Android 11-16)
resetprop -n debug.tracing.disabled 1
resetprop -n persist.debug.trace 0
resetprop -n persist.sys.ui.animation 0
resetprop -n debug.hwui.profile false
resetprop -n debug.hwui.overdraw false
resetprop -n debug.layout false
resetprop -n debug.performance.tuning 0
resetprop -n persist.sys.dalvik.vm.lib.2 libart.so
resetprop -n dalvik.vm.usejit true
resetprop -n dalvik.vm.usejitprofiles true
resetprop -n dalvik.vm.dexopt.secondary true
resetprop -n pm.dexopt.bg-dexopt speed
resetprop -n pm.dexopt.install speed
resetprop -n pm.dexopt.shared speed
resetprop -n pm.dexopt.boot speed

# ART optimization for Android 11+
resetprop -n dalvik.vm.dex2oat-filter speed
resetprop -n dalvik.vm.image-dex2oat-filter speed
resetprop -n dalvik.vm.check-dex-sum false
resetprop -n dalvik.vm.dex2oat-minidebuginfo false
resetprop -n dalvik.vm.minidebuginfo false
resetprop -n dalvik.vm.verify-bytecode false
resetprop -n dalvik.vm.deadlock-predict false
resetprop -n dalvik.vm.enable-assertions false
resetprop -n dalvik.vm.enable-profiler false

# Disabling AI/ML tracking (Android 12+)
resetprop -n persist.traced.enable 0
resetprop -n persist.traced_perf.enable 0
resetprop -n persist.debug.aml.enable 0
resetprop -n persist.debug.ml.enable 0
resetprop -n debug.ml.shutdown 1

# Safe Performance Settings (Android 11-16)
resetprop -n debug.sf.enable_gl_backpressure 0
resetprop -n debug.sf.enable_hwc_vds 1
resetprop -n debug.sf.latch_unsignaled 1
resetprop -n debug.cpurend.vsync false
resetprop -n ro.surface_flinger.max_frame_buffer_acquired_buffers 3
resetprop -n ro.surface_flinger.running_without_sync_framework true

# Memory optimization (Android 11+)
resetprop -n ro.config.fha_enable true
resetprop -n ro.sys.fw.bg_apps_limit 32
resetprop -n ro.sys.fw.empty_app_percent 50
resetprop -n ro.sys.fw.trim_empty_percent 100
resetprop -n ro.sys.fw.trim_cache_percent 100
resetprop -n ro.sys.fw.bservice_enable true
resetprop -n ro.sys.fw.bservice_limit 5
resetprop -n ro.sys.fw.bservice_age 5000

# Disabling unnecessary services (safely)
resetprop -n config.disable_consumerir true
resetprop -n config.disable_bluetooth_dual_mode true
resetprop -n config.disable_audio_effects true

# Network Optimization (Android 11+)
resetprop -n net.tcp.buffersize.default 4096,87380,524288,4096,16384,110208
resetprop -n net.tcp.buffersize.wifi 4096,87380,524288,4096,16384,110208
resetprop -n net.tcp.buffersize.lte 4096,87380,524288,4096,16384,110208
resetprop -n net.tcp.buffersize.umts 4096,87380,524288,4096,16384,110208
resetprop -n net.tcp.buffersize.hspa 4096,87380,524288,4096,16384,110208
resetprop -n net.tcp.buffersize.edge 4096,87380,524288,4096,16384,110208
resetprop -n net.tcp.buffersize.gprs 4096,87380,524288,4096,16384,110208

# Secure kernel settings (if available)
echo "100" > /proc/sys/vm/swappiness 2>/dev/null
echo "100" > /proc/sys/vm/vfs_cache_pressure 2>/dev/null
echo "60" > /proc/sys/vm/dirty_ratio 2>/dev/null
echo "20" > /proc/sys/vm/dirty_background_ratio 2>/dev/null
echo "500" > /proc/sys/vm/dirty_expire_centisecs 2>/dev/null
echo "1000" > /proc/sys/vm/dirty_writeback_centisecs 2>/dev/null
echo "1" > /proc/sys/vm/page-cluster 2>/dev/null
echo "0" > /proc/sys/vm/oom_kill_allocating_task 2>/dev/null

# Input/Output Optimization (Android 11+)
for block in /sys/block/*/queue; do
    [ -e "$block/scheduler" ] && echo "cfq" > "$block/scheduler" 2>/dev/null
    [ -e "$block/read_ahead_kb" ] && echo "256" > "$block/read_ahead_kb" 2>/dev/null
    [ -e "$queue/nr_requests" ] && echo "128" > "$queue/nr_requests" 2>/dev/null
    [ -e "$queue/iostats" ] && echo "0" > "$queue/iostats" 2>/dev/null
    [ -e "$queue/add_random" ] && echo "0" > "$queue/add_random" 2>/dev/null
    [ -e "$queue/rq_affinity" ] && echo "1" > "$queue/rq_affinity" 2>/dev/null
done

# Disabling unnecessary debugging features (Android 11-16)
for debugfs in /sys/kernel/debug/*; do
    [ -e "$debugfs/tracing/tracing_on" ] && echo "0" > "$debugfs/tracing/tracing_on" 2>/dev/null
    [ -e "$debugfs/tracing/events/enable" ] && echo "0" > "$debugfs/tracing/events/enable" 2>/dev/null
done

# Clearing the Event Cache (Android 12+)
resetprop -n persist.logd.security_events false
resetprop -n persist.logd.auditd.enabled false
resetprop -n persist.logd.kernel false

# Battery optimization (safe)
resetprop -n persist.vendor.camera.eis.enable 0
resetprop -n persist.vendor.camera.faceproc 0
resetprop -n persist.vendor.camera.hal.debug 0
resetprop -n persist.vendor.camera.stats.test 0

# Disabling unnecessary security checks in development
resetprop -n ro.secure 1
resetprop -n ro.adb.secure 1
resetprop -n ro.debuggable 0
resetprop -n ro.allow.mock.location 0

# Finalization - synchronization and cleanup
sync
echo "3" > /proc/sys/vm/drop_caches 2>/dev/null
echo "1" > /proc/sys/vm/compact_memory 2>/dev/null

exit 0