#!/system/bin/sh
MODDIR="${0%/*}"
CFG="/data/adb/modules/UltrOpt/mod.cfg"
MARK="/data/adb/modules/UltrOpt/.gov_inited"
LOG="/data/local/tmp/UltraOpt_service.log"
SLEEP_PRIORITY="powersave conservative ondemand schedutil interactive blu_schedutil blu_active darkness zzmoove lionheart yankactive alucard smartmax smartassh3 smartassv2 intelliactive intellimm interactive_pro interactivex impulse pegasusq nightmare relaxed barrier"
DEFAULT_PRIORITY="schedutil blu_schedutil ondemand interactive blu_active conservative smartmax alucard intelliactive intellimm smartassh3 smartassv2 zzmoove darkness lionheart yankactive interactive_pro interactivex impulse pegasusq nightmare relaxed barrier powersave"
w(){ [ -f "$1" ] && { chmod +w "$1" 2>/dev/null; echo "$2" > "$1" 2>/dev/null; } }
log(){ echo "[UltraOpt][$(date '+%Y-%m-%d %H:%M:%S')] $*" >> "$LOG" 2>/dev/null;}
choose(){ local a="$1" l="$2"; for g in $l; do echo " $a " | grep -q " $g " && { echo "$g"; return; }; done; echo "";}
hn(){ grep -q "^$1=[^[:space:]]" "$CFG" 2>/dev/null;}
ce(){ local k="$1" v="$2"; [ -z "$v" ] && return; [ ! -f "$CFG" ] && return 1; hn "$k" && return; if grep -q "^$k=" "$CFG" 2>/dev/null; then sed -i "s/^$k=.*/$k=$v/" "$CFG" 2>/dev/null; else echo "$k=$v" >> "$CFG"; fi;}
cg(){ [ -f /sys/devices/system/cpu/cpufreq/policy0/scaling_governor ] && cat /sys/devices/system/cpu/cpufreq/policy0/scaling_governor 2>/dev/null && return; [ -f /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor ] && cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor 2>/dev/null && return; echo "";}
ag(){ [ -f /sys/devices/system/cpu/cpufreq/policy0/scaling_available_governors ] && cat /sys/devices/system/cpu/cpufreq/policy0/scaling_available_governors 2>/dev/null && return; [ -f /sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors ] && cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors 2>/dev/null && return; echo "";}
cs(){ for p in /sys/devices/system/cpu/cpufreq/policy*/scaling_governor /sys/devices/system/cpu/cpu*/cpufreq/scaling_governor; do [ -w "$p" ] && return 0; done; return 1;}
gp(){ for p in /sys/class/kgsl/kgsl-3d0/devfreq/governor /sys/class/devfreq/*gpu*/governor /sys/class/devfreq/*mali*/governor /sys/class/devfreq/*GPU*/governor; do [ -f "$p" ] && { echo "$p"; return; }; done; echo "";}
gg(){ local P="$(gp)"; [ -n "$P" ] && cat "$P" 2>/dev/null;}
ga(){ local P="$(gp)"; [ -n "$P" ] && cat "${P%/governor}/available_governors" 2>/dev/null;}
gs(){ local P="$(gp)"; [ -n "$P" ] && [ -w "$P" ];}

log "UltraOpt service starting"
until [ "$(getprop sys.boot_completed)" = "1" ]; do sleep 3; done
sleep 5
log "System boot completed"
log "Applying system optimizations (every boot)"
cmd settings put global ble_scan_always_enabled 0 2>/dev/null
cmd settings put global wifi_scan_always_enabled 0 2>/dev/null
cmd settings put global network_recommendations_enabled 0 2>/dev/null
cmd settings put global mobile_data_always_on 0 2>/dev/null
cmd settings put global activity_starts_logging_enabled 0 2>/dev/null
cmd settings put global hotword_detection_enabled 0 2>/dev/null
cmd settings put global cached_apps_freezer disabled 2>/dev/null
cmd settings put global sem_enhanced_cpu_responsiveness 0 2>/dev/null
cmd settings put global enhanced_processing 0 2>/dev/null
cmd settings put global app_standby_enabled 0 2>/dev/null
cmd settings put global adaptive_battery_management_enabled 0 2>/dev/null
cmd settings put global app_restriction_enabled true 2>/dev/null
cmd settings put global automatic_power_save_mode 0 2>/dev/null
cmd settings put global low_power 0 2>/dev/null
cmd settings put global dynamic_power_savings_enabled 0 2>/dev/null
cmd settings put global dynamic_power_savings_disable_threshold 20 2>/dev/null
cmd settings put secure adaptive_sleep 0 2>/dev/null
cmd settings put secure screensaver_enabled 0 2>/dev/null
cmd settings put secure screensaver_activate_on_dock 0 2>/dev/null
cmd settings put secure screensaver_activate_on_sleep 0 2>/dev/null
cmd settings put secure send_action_app_error 0 2>/dev/null
cmd settings put secure wake_locks_enabled 0 2>/dev/null
cmd settings put secure location_scanning_interval 1800000 2>/dev/null
cmd settings put secure doze_always_on 1 2>/dev/null
cmd settings put secure alarm_manager_constants 1 2>/dev/null
cmd settings put system intelligent_sleep_mode 0 2>/dev/null
cmd settings put system master_motion 0 2>/dev/null
cmd settings put system motion_engine 0 2>/dev/null
cmd settings put system air_motion_engine 0 2>/dev/null
cmd settings put system air_motion_wake_up 0 2>/dev/null
cmd settings put system nearby_scanning_enabled 0 2>/dev/null
cmd settings put system nearby_scanning_permission_allowed 0 2>/dev/null
cmd settings put system rakuten_denwa 0 2>/dev/null
cmd settings put system send_security_reports 0 2>/dev/null
cmd settings put global wifi_sleep_policy 2 2>/dev/null
stop logcat logcatd logd tcpdump cnss_diag statsd traced idd-logreader idd-logreadermain stats dumpstate aplogd tcpdump vendor.tcpdump vendor_tcpdump vendor.cnss_diag 2>/dev/null
pm disable-user --user 0 com.android.traceur 2>/dev/null
pm disable com.google.android.gms/.chimera.GmsIntentOperationService 2>/dev/null
pm disable com.google.android.gms/com.google.android.gms.mdm.receivers.MdmDeviceAdminReceiver 2>/dev/null
rm -rf /data/vendor/wlan_logs 2>/dev/null
touch /data/vendor/wlan_logs 2>/dev/null
chmod 000 /data/vendor/wlan_logs 2>/dev/null

resetprop -n debug.sf.dump 0 2>/dev/null
resetprop -n debug.sf.ddms 0 2>/dev/null
resetprop -n persist.traced.enable false 2>/dev/null
resetprop -n persist.traced_perf.enable false 2>/dev/null
resetprop -n ro.statsd.enable false 2>/dev/null

for p in /sys/module/mmc_core/parameters/*; do echo '0' > "$p/crc" 2>/dev/null; echo '0' > "$p/removable" 2>/dev/null; done
for p in /sys/kernel/printk_mode/printk_mode /sys/module/printk/parameters/cpu /sys/module/printk/parameters/pid /sys/module/printk/parameters/printk_ratelimit /sys/module/printk/parameters/time; do echo '0' > "$p" 2>/dev/null; done
echo '1' > /sys/module/printk/parameters/console_suspend 2>/dev/null
echo '1' > /sys/module/printk/parameters/ignore_loglevel 2>/dev/null
echo '0' > /sys/module/msm_perfmon/parameters/touch_boost_enable 2>/dev/null
echo '0' > /sys/module/msm_perfmon/parameters/touch_boost_freq 2>/dev/null
echo '0' > /sys/module/msm_performance/parameters/touchboost 2>/dev/null
echo '0' > /sys/power/pnpmgr/touch_boost 2>/dev/null
for p in /proc/sys/fs/by-name/userdata/iostat_enable /proc/sys/fs/dir-notify-enable; do echo '0' > "$p" 2>/dev/null; done
for p in /sys/module/subsystem_restart/parameters/enable_mini_ramdumps /sys/module/subsystem_restart/parameters/enable_ramdumps; do echo '0' > "$p" 2>/dev/null; done

[ -f "$CFG" ] && [ "$(grep -m1 "^AGGRESSIVE_LOGS=" "$CFG" 2>/dev/null | cut -d= -f2)" = "1" ] && {
    log "Aggressive logging cleanup"
    rm -rf /data/system/dropbox/* /data/anr/* /data/tombstones/* /data/misc/logd/* 2>/dev/null
}
log "System optimizations completed"

[ ! -f "$MARK" ] && {
    log "Starting auto governor configuration (first time)"
    CPU_DEFAULT=""; CPU_SLEEP=""; GPU_DEFAULT=""; GPU_SLEEP=""
    
    cs && {
        CPU_AVAIL="$(ag)"; CPU_CUR="$(cg)"
        CPU_DEFAULT="$(choose "$CPU_AVAIL" "$DEFAULT_PRIORITY")"
        CPU_SLEEP="$(choose "$CPU_AVAIL" "$SLEEP_PRIORITY")"
        [ -z "$CPU_DEFAULT" ] && CPU_DEFAULT="$CPU_CUR"
        [ -z "$CPU_SLEEP" ] && CPU_SLEEP="$CPU_CUR"
        log "CPU available: $CPU_AVAIL"
        log "CPU chosen: DEFAULT=$CPU_DEFAULT, SLEEP=$CPU_SLEEP"
    } || log "CPU governor control not available"
    
    gs && {
        GPU_AVAIL="$(ga)"; GPU_CUR="$(gg)"
        GPU_DEFAULT="$(choose "$GPU_AVAIL" "$DEFAULT_PRIORITY")"
        GPU_SLEEP="$(choose "$GPU_AVAIL" "$SLEEP_PRIORITY")"
        [ -z "$GPU_DEFAULT" ] && GPU_DEFAULT="$GPU_CUR"
        [ -z "$GPU_SLEEP" ] && GPU_SLEEP="$GPU_CUR"
        log "GPU available: $GPU_AVAIL"
        log "GPU chosen: DEFAULT=$GPU_DEFAULT, SLEEP=$GPU_SLEEP"
    } || log "GPU governor control not available"
    
    [ ! -f "$CFG" ] && {
        log "Creating new config file"
        umask 077
        {
            echo "# ================================"
            echo "# UltraOpt Configuration File"
            echo "# ================================"
            echo "# Auto-generated on $(date)"
            echo "# CPU governors"
            echo "DEFAULT_GOV=$CPU_DEFAULT"
            echo "SLEEP_GOV=$CPU_SLEEP"
            echo "# GPU governors (optional)"
            echo "DEFAULT_GPU_GOV=$GPU_DEFAULT"
            echo "SLEEP_GPU_GOV=$GPU_SLEEP"
            echo "# General settings"
            echo "CHECK_INTERVAL=8"
            echo "AGGRESSIVE_LOGS=0"
            echo "RESPECT_USER_OVERRIDE=1"
            echo "ENABLE_KERNEL_SLEEP=1"
        } > "$CFG"
    } || {
        log "Updating existing config with missing values"
        ce "DEFAULT_GOV" "$CPU_DEFAULT"
        ce "SLEEP_GOV" "$CPU_SLEEP"
        ce "DEFAULT_GPU_GOV" "$GPU_DEFAULT"
        ce "SLEEP_GPU_GOV" "$GPU_SLEEP"
        hn "CHECK_INTERVAL" || ce "CHECK_INTERVAL" "8"
        hn "AGGRESSIVE_LOGS" || ce "AGGRESSIVE_LOGS" "0"
        hn "RESPECT_USER_OVERRIDE" || ce "RESPECT_USER_OVERRIDE" "1"
        hn "ENABLE_KERNEL_SLEEP" || ce "ENABLE_KERNEL_SLEEP" "0"
    }
    
    touch "$MARK" 2>/dev/null
    log "Auto governor configuration completed and marked"
} || log "Auto governor config already done (MARK exists)"

log "Starting hibernation daemon"
hibernation & echo $! > /data/adb/modules/UltrOpt/.hib.pid
log "The daemon has been started successfully!"