#!/system/bin/sh
# ===========================================
# ULTIMATE GAMING PERFORMANCE BOOSTER
# FULL PERFORMANCE EDITION - Android 10-16
# Compatible: Snapdragon | MediaTek | Exynos | Kirin
# Features: MAX Performance | Ultra Stable FPS | No Throttle
# ===========================================

# Check root
if [[ "$(id -u)" -ne 0 ]]; then
    echo "❌ No root permissions. Exiting."
    exit 1
fi

# Mount system as RW
mount -o remount,rw /system 2>/dev/null
mount -o remount,rw / 2>/dev/null

# System info
memTotal=$(free -m | awk '/^Mem:/{print $2}' 2>/dev/null || echo "0")
cpuCores=$(grep -c ^processor /proc/cpuinfo 2>/dev/null || echo "8")
androidVersion=$(getprop ro.build.version.sdk 2>/dev/null || echo "29")

# Enhanced Chipset Detection
detect_chipset() {
    echo "🔍 Detecting Chipset..."
    
    # Multiple detection methods
    local platform=$(getprop ro.board.platform 2>/dev/null | tr '[:upper:]' '[:lower:]')
    local chipname=$(getprop ro.chipname 2>/dev/null | tr '[:upper:]' '[:lower:]')
    local hardware=$(getprop ro.hardware 2>/dev/null | tr '[:upper:]' '[:lower:]')
    local soc_id=$(cat /sys/devices/soc0/soc_id 2>/dev/null 2>/dev/null || cat /sys/devices/system/soc/soc0/id 2>/dev/null)
    
    # GPU based detection (most accurate)
    if [[ -d "/sys/class/kgsl/kgsl-3d0" ]] || [[ -d "/sys/class/kgsl/kgsl-3d0" ]]; then
        echo "✅ Snapdragon Detected (Adreno GPU)"
        echo "SNAPDRAGON"
        return
    fi
    
    if [[ -d "/proc/mali" ]] || [[ -d "/sys/class/misc/mali0" ]] || [[ -d "/sys/devices/platform/mali.0" ]]; then
        if [[ "$platform" == *"mt"* ]] || [[ "$chipname" == *"mt"* ]] || [[ "$hardware" == *"mt"* ]]; then
            echo "✅ MediaTek Detected (Mali GPU)"
            echo "MEDIATEK"
        elif [[ "$platform" == *"exynos"* ]] || [[ "$chipname" == *"exynos"* ]] || [[ "$hardware" == *"exynos"* ]]; then
            echo "✅ Exynos Detected (Mali GPU)"
            echo "EXYNOS"
        else
            echo "✅ Mali GPU Detected"
            echo "MALI"
        fi
        return
    fi
    
    # Platform pattern matching
    if [[ "$platform" == *"msm"* ]] || [[ "$platform" == *"qcom"* ]] || [[ "$platform" == *"sdm"* ]] || \
       [[ "$platform" == *"sm"* ]] || [[ "$chipname" == *"qcom"* ]]; then
        echo "✅ Snapdragon Detected"
        echo "SNAPDRAGON"
    elif [[ "$platform" == *"mt"* ]] || [[ "$chipname" == *"mt"* ]] || [[ "$platform" == *"helio"* ]] || \
         [[ "$platform" == *"dimensity"* ]] || [[ "$chipname" == *"helio"* ]]; then
        echo "✅ MediaTek Detected"
        echo "MEDIATEK"
    elif [[ "$platform" == *"exynos"* ]] || [[ "$chipname" == *"exynos"* ]] || [[ "$soc_id" == *"exynos"* ]]; then
        echo "✅ Exynos Detected"
        echo "EXYNOS"
    elif [[ "$platform" == *"kirin"* ]] || [[ "$chipname" == *"kirin"* ]] || [[ "$platform" == *"hi"* ]]; then
        echo "✅ Kirin Detected"
        echo "KIRIN"
    elif dmesg | grep -qi "qualcomm" || dmesg | grep -qi "qcom"; then
        echo "✅ Snapdragon Detected (Kernel log)"
        echo "SNAPDRAGON"
    elif dmesg | grep -qi "mediatek" || dmesg | grep -qi "mt"; then
        echo "✅ MediaTek Detected (Kernel log)"
        echo "MEDIATEK"
    else
        echo "⚠️  Universal Chipset Mode"
        echo "UNIVERSAL"
    fi
}

# Get chipset
chipset=$(detect_chipset)

echo "=========================================="
echo "🔥 ULTIMATE GAMING PERFORMANCE BOOSTER 🔥"
echo "=========================================="
echo "Chipset: $chipset"
echo "Cores: $cpuCores | RAM: ${memTotal}MB"
echo "Android API: $androidVersion"
echo "=========================================="

# Aggressive safe write
safe_write() {
    local file="$1"
    local value="$2"
    
    # Try multiple times
    for i in 1 2 3; do
        if [[ -f "$file" ]] || [[ -d "$(dirname "$file")" ]]; then
            echo "$value" > "$file" 2>/dev/null
            if [[ $? -eq 0 ]]; then
                echo "✅ $(basename "$file") = $value"
                return 0
            fi
            sleep 0.01
        fi
    done
    return 1
}

# Set ALL CPUs to MAX frequency and performance governor
force_max_cpu() {
    echo "⚡ FORCING ALL CPUS TO MAX PERFORMANCE..."
    
    # Disable hotplugging first
    for hotplug in /sys/devices/system/cpu/cpu*/online; do
        [[ -f "$hotplug" ]] && safe_write "$hotplug" "1"
    done
    
    # Set all cores online
    safe_write "/sys/devices/system/cpu/cpu0/core_ctl/min_cpus" "$cpuCores"
    safe_write "/sys/devices/system/cpu/cpu0/core_ctl/max_cpus" "$cpuCores"
    safe_write "/sys/devices/system/cpu/cpu0/core_ctl/enable" "0"
    
    # Force performance governor on ALL cores
    for cpu in /sys/devices/system/cpu/cpu*/cpufreq; do
        if [[ -d "$cpu" ]]; then
            # Get max frequency
            local max_freq=$(cat "$cpu/cpuinfo_max_freq" 2>/dev/null)
            local min_freq=$(cat "$cpu/cpuinfo_min_freq" 2>/dev/null)
            
            # Set to performance governor
            safe_write "$cpu/scaling_governor" "performance"
            
            # Lock at max frequency
            [[ -n "$max_freq" ]] && safe_write "$cpu/scaling_max_freq" "$max_freq"
            [[ -n "$max_freq" ]] && safe_write "$cpu/scaling_min_freq" "$max_freq"
            [[ -n "$min_freq" ]] && safe_write "$cpu/scaling_min_freq" "$min_freq"
            
            # Disable CPU boost limitations
            [[ -f "$cpu/boost" ]] && safe_write "$cpu/boost" "1"
            [[ -f "$cpu/boostpulse" ]] && safe_write "$cpu/boostpulse" "1"
            [[ -f "$cpu/boostpulse_duration" ]] && safe_write "$cpu/boostpulse_duration" "2000"
        fi
    done
    
    # Additional CPU tweaks
    [[ -f "/sys/module/cpu_boost/parameters/input_boost_freq" ]] && \
        safe_write "/sys/module/cpu_boost/parameters/input_boost_freq" "0:0 1:0 2:0 3:0 4:0 5:0 6:0 7:0"
    
    [[ -f "/sys/module/cpu_boost/parameters/input_boost_ms" ]] && \
        safe_write "/sys/module/cpu_boost/parameters/input_boost_ms" "2000"
    
    [[ -f "/sys/module/cpu_boost/parameters/sync_threshold" ]] && \
        safe_write "/sys/module/cpu_boost/parameters/sync_threshold" "0"
    
    echo "✅ All CPUs locked at MAX performance"
}

# Extreme GPU Optimization
force_max_gpu() {
    echo "🎮 FORCING GPU TO MAX PERFORMANCE..."
    
    case "$chipset" in
        "SNAPDRAGON")
            # Adreno GPU MAX
            for gpu in /sys/class/kgsl/kgsl-3d0; do
                if [[ -d "$gpu" ]]; then
                    echo "🔥 MAXIMIZING ADRENO GPU..."
                    
                    # Power levels
                    safe_write "$gpu/max_pwrlevel" "0"
                    safe_write "$gpu/min_pwrlevel" "0"
                    safe_write "$gpu/default_pwrlevel" "0"
                    
                    # Force always on
                    safe_write "$gpu/force_no_nap" "1"
                    safe_write "$gpu/force_bus_on" "1"
                    safe_write "$gpu/force_clk_on" "1"
                    safe_write "$gpu/force_rail_on" "1"
                    
                    # Disable idle
                    safe_write "$gpu/idle_timer" "1000000"
                    safe_write "$gpu/bus_split" "0"
                    
                    # Governor
                    [[ -f "$gpu/devfreq/governor" ]] && \
                        safe_write "$gpu/devfreq/governor" "performance"
                    
                    # Set max frequency
                    [[ -f "$gpu/max_gpuclk" ]] && {
                        local max_gpuclk=$(cat "$gpu/max_gpuclk" 2>/dev/null)
                        safe_write "$gpu/gpuclk" "$max_gpuclk"
                    }
                fi
            done
            
            # Adreno booster
            [[ -f "/sys/class/kgsl/kgsl-3d0/devfreq/adrenoboost" ]] && \
                safe_write "/sys/class/kgsl/kgsl-3d0/devfreq/adrenoboost" "3"
            ;;
            
        "MEDIATEK"|"EXYNOS"|"MALI")
            # Mali GPU MAX
            for gpu in /sys/devices/platform/*.mali /sys/class/misc/mali* /sys/devices/*.gpu; do
                if [[ -d "$gpu" ]]; then
                    echo "🔥 MAXIMIZING MALI GPU..."
                    
                    # Disable DVFS
                    [[ -f "$gpu/dvfs" ]] && safe_write "$gpu/dvfs" "0"
                    [[ -f "$gpu/dvfs_enable" ]] && safe_write "$gpu/dvfs_enable" "0"
                    
                    # Force max clock
                    [[ -f "$gpu/clock" ]] && safe_write "$gpu/clock" "max"
                    [[ -f "$gpu/max_clock" ]] && safe_write "$gpu/max_clock" "$(cat "$gpu/max_clock")"
                    
                    # Always on
                    [[ -f "$gpu/force_clk_on" ]] && safe_write "$gpu/force_clk_on" "1"
                    [[ -f "$gpu/force_rail_on" ]] && safe_write "$gpu/force_rail_on" "1"
                    [[ -f "$gpu/always_on" ]] && safe_write "$gpu/always_on" "1"
                    
                    # Governor
                    [[ -f "$gpu/devfreq/governor" ]] && \
                        safe_write "$gpu/devfreq/governor" "performance"
                fi
            done
            
            # MediaTek specific GPU controls
            if [[ "$chipset" == "MEDIATEK" ]]; then
                [[ -f "/proc/gpufreq/gpufreq_opp_freq" ]] && \
                    echo "max" > /proc/gpufreq/gpufreq_opp_freq 2>/dev/null
                [[ -f "/proc/gpufreq/gpufreq_input_boost" ]] && \
                    safe_write "/proc/gpufreq/gpufreq_input_boost" "1"
            fi
            ;;
    esac
    
    echo "✅ GPU locked at MAX performance"
}

# Disable ALL thermal throttling
disable_thermal_throttle() {
    echo "❄️  DISABLING THERMAL THROTTLING..."
    
    # Disable thermal core control
    [[ -f "/sys/module/msm_thermal/core_control/enabled" ]] && \
        safe_write "/sys/module/msm_thermal/core_control/enabled" "0"
    
    [[ -f "/sys/module/msm_thermal/parameters/enabled" ]] && \
        safe_write "/sys/module/msm_thermal/parameters/enabled" "N"
    
    # Increase thermal thresholds significantly
    for thermal in /sys/class/thermal/thermal_zone*; do
        if [[ -d "$thermal" ]]; then
            local type=$(cat "$thermal/type" 2>/dev/null)
            
            # Increase trip points for CPU/GPU
            if [[ "$type" == *"cpu"* ]] || [[ "$type" == *"gpu"* ]] || [[ "$type" == *"batt"* ]]; then
                for trip in "$thermal"/trip_point_*_temp; do
                    if [[ -f "$trip" ]]; then
                        local current=$(cat "$trip" 2>/dev/null)
                        if [[ -n "$current" ]] && [[ "$current" -lt 110000 ]]; then
                            local new_temp=$((current + 15000))
                            safe_write "$trip" "$new_temp"
                        fi
                    fi
                done
            fi
        fi
    done
    
    # Chipset specific thermal disable
    case "$chipset" in
        "SNAPDRAGON")
            safe_write "/sys/module/msm_thermal/parameters/limit_temp_degC" "110"
            safe_write "/sys/module/msm_thermal/parameters/core_limit_temp_degC" "110"
            ;;
        "MEDIATEK")
            [[ -f "/proc/mtk_thermal_control/enabled" ]] && \
                safe_write "/proc/mtk_thermal_control/enabled" "0"
            [[ -f "/proc/mtk_thermal_control/temp_limit" ]] && \
                safe_write "/proc/mtk_thermal_control/temp_limit" "110000"
            ;;
    esac
    
    echo "✅ Thermal throttling disabled"
}

# Extreme Memory Optimization for Gaming
optimize_memory_extreme() {
    echo "💾 EXTREME MEMORY OPTIMIZATION..."
    
    # Aggressive VM settings
    safe_write "/proc/sys/vm/swappiness" "10"
    safe_write "/proc/sys/vm/vfs_cache_pressure" "20"
    safe_write "/proc/sys/vm/dirty_ratio" "5"
    safe_write "/proc/sys/vm/dirty_background_ratio" "1"
    safe_write "/proc/sys/vm/dirty_expire_centisecs" "100"
    safe_write "/proc/sys/vm/dirty_writeback_centisecs" "500"
    safe_write "/proc/sys/vm/page-cluster" "0"
    safe_write "/proc/sys/vm/oom_kill_allocating_task" "1"
    safe_write "/proc/sys/vm/overcommit_memory" "1"
    safe_write "/proc/sys/vm/overcommit_ratio" "100"
    
    # Clear ALL caches aggressively
    sync
    echo 3 > /proc/sys/vm/drop_caches 2>/dev/null
    echo 1 > /proc/sys/vm/compact_memory 2>/dev/null
    
    # Disable memory compression (zRAM)
    for zram in /sys/block/zram*; do
        if [[ -d "$zram" ]]; then
            safe_write "$zram/reset" "1"
            safe_write "$zram/disksize" "0"
        fi
    done
    
    # LMK aggressive settings for gaming
    [[ -f "/sys/module/lowmemorykiller/parameters/minfree" ]] && \
        safe_write "/sys/module/lowmemorykiller/parameters/minfree" "18432,23040,27648,32256,55296,80640"
    
    echo "✅ Extreme memory optimization complete"
}

# Ultimate I/O Optimization
optimize_io_ultimate() {
    echo "⚡ ULTIMATE I/O OPTIMIZATION..."
    
    for block in /sys/block/mmcblk* /sys/block/sd*; do
        if [[ -d "$block/queue" ]]; then
            local queue="$block/queue"
            
            # Set to fastest scheduler
            if [[ -f "$queue/scheduler" ]]; then
                if grep -q "noop" "$queue/scheduler"; then
                    safe_write "$queue/scheduler" "noop"
                elif grep -q "deadline" "$queue/scheduler"; then
                    safe_write "$queue/scheduler" "deadline"
                fi
            fi
            
            # Extreme I/O settings
            safe_write "$queue/read_ahead_kb" "8192"
            safe_write "$queue/nr_requests" "2048"
            safe_write "$queue/add_random" "0"
            safe_write "$queue/iostats" "0"
            safe_write "$queue/rotational" "0"
            safe_write "$queue/rq_affinity" "2"
            safe_write "$queue/nomerges" "2"
            
            # Flash specific optimizations
            if [[ "$(basename "$block")" == mmcblk* ]]; then
                [[ -f "$queue/iosched/slice_idle" ]] && safe_write "$queue/iosched/slice_idle" "0"
                [[ -f "$queue/iosched/quantum" ]] && safe_write "$queue/iosched/quantum" "256"
                [[ -f "$queue/iosched/fifo_batch" ]] && safe_write "$queue/iosched/fifo_batch" "32"
            fi
        fi
    done
    
    # Increase I/O scheduler tunables
    for iosched in /sys/block/*/queue/iosched; do
        if [[ -d "$iosched" ]]; then
            [[ -f "$iosched/read_expire" ]] && safe_write "$iosched/read_expire" "100"
            [[ -f "$iosched/write_expire" ]] && safe_write "$iosched/write_expire" "5000"
            [[ -f "$iosched/writes_starved" ]] && safe_write "$iosched/writes_starved" "2"
        fi
    done
    
    echo "✅ Ultimate I/O optimization complete"
}

# Kill ALL background processes aggressively
kill_background_processes() {
    echo "💀 KILLING BACKGROUND PROCESSES..."
    
    # List of processes to KILL for gaming
    local processes_to_kill=(
        # Social Media
        "com.facebook.katana" "com.facebook.orca" "com.instagram.android"
        "com.whatsapp" "com.twitter.android" "com.snapchat.android"
        
        # Messaging
        "com.google.android.gm" "com.android.mms" "com.android.email"
        "com.samsung.android.messaging" "org.telegram.messenger"
        
        # Browsers
        "com.android.chrome" "com.sec.android.app.sbrowser"
        "com.opera.browser" "com.brave.browser"
        
        # Media
        "com.spotify.music" "com.netflix.mediaclient" "com.google.android.youtube"
        "com.amazon.avod.thirdpartyclient" "com.google.android.apps.photos"
        
        # System apps that can be paused
        "com.google.android.apps.docs" "com.google.android.apps.maps"
        "com.google.android.calculator" "com.google.android.calendar"
        
        # Launchers (except default)
        "com.nova.launcher" "com.teslacoilsw.launcher" "org.adw.launcher"
    )
    
    # Force stop ALL user apps
    local user_apps=$(pm list packages -3 2>/dev/null | cut -d: -f2)
    for app in $user_apps; do
        # Skip gaming apps
        if [[ ! "$app" =~ "com.activision" ]] && \
           [[ ! "$app" =~ "com.ea.game" ]] && \
           [[ ! "$app" =~ "com.gameloft" ]] && \
           [[ ! "$app" =~ "com.mojang" ]] && \
           [[ ! "$app" =~ "com.tencent" ]] && \
           [[ ! "$app" =~ "com.supercell" ]] && \
           [[ ! "$app" =~ "com.mobilelegends" ]] && \
           [[ ! "$app" =~ "com.pubg" ]] && \
           [[ ! "$app" =~ "com.dts.freefireth" ]] && \
           [[ ! "$app" =~ "com.riotgames" ]]; then
            am force-stop "$app" 2>/dev/null
        fi
    done
    
    # Kill specific system services
    am kill-all 2>/dev/null
    
    # Stop Android services
    stop cn.google.config 2>/dev/null
    stop logd 2>/dev/null
    stop traced 2>/dev/null
    stop statsd 2>/dev/null
    stop tombstoned 2>/dev/null
    
    echo "✅ Background processes terminated"
}

# Extreme Network Optimization for Gaming
optimize_network_extreme() {
    echo "📡 EXTREME NETWORK OPTIMIZATION..."
    
    # TCP buffers for gaming
    setprop net.tcp.buffersize.default "8192,87380,524288,8192,16384,524288"
    setprop net.tcp.buffersize.wifi "1048576,2097152,4194304,1048576,2097152,4194304"
    setprop net.tcp.buffersize.lte "1048576,2097152,4194304,1048576,2097152,4194304"
    setprop net.tcp.buffersize.umts "6144,87380,524288,6144,16384,524288"
    setprop net.tcp.buffersize.hspa "6144,87380,524288,6144,16384,524288"
    setprop net.tcp.buffersize.edge "4096,87380,262144,4096,16384,262144"
    
    # Extreme TCP optimizations
    safe_write "/proc/sys/net/ipv4/tcp_timestamps" "1"
    safe_write "/proc/sys/net/ipv4/tcp_tw_reuse" "1"
    safe_write "/proc/sys/net/ipv4/tcp_sack" "1"
    safe_write "/proc/sys/net/ipv4/tcp_dsack" "1"
    safe_write "/proc/sys/net/ipv4/tcp_fack" "1"
    safe_write "/proc/sys/net/ipv4/tcp_window_scaling" "1"
    safe_write "/proc/sys/net/ipv4/tcp_keepalive_time" "1800"
    safe_write "/proc/sys/net/ipv4/tcp_keepalive_probes" "5"
    safe_write "/proc/sys/net/ipv4/tcp_keepalive_intvl" "30"
    safe_write "/proc/sys/net/ipv4/tcp_slow_start_after_idle" "0"
    safe_write "/proc/sys/net/ipv4/tcp_mtu_probing" "1"
    safe_write "/proc/sys/net/ipv4/tcp_base_mss" "1460"
    
    # Network priority
    safe_write "/proc/sys/net/ipv4/ip_no_pmtu_disc" "0"
    safe_write "/proc/sys/net/ipv4/tcp_ecn" "1"
    safe_write "/proc/sys/net/ipv4/tcp_frto" "1"
    safe_write "/proc/sys/net/ipv4/tcp_frto_response" "2"
    
    # Increase connection limits
    safe_write "/proc/sys/net/core/netdev_max_backlog" "5000"
    safe_write "/proc/sys/net/core/somaxconn" "2048"
    safe_write "/proc/sys/net/ipv4/tcp_max_syn_backlog" "4096"
    safe_write "/proc/sys/net/ipv4/tcp_max_tw_buckets" "180000"
    
    # Disable IPv6 for gaming (some games have issues)
    safe_write "/proc/sys/net/ipv6/conf/all/disable_ipv6" "1"
    
    echo "✅ Extreme network optimization complete"
}

# Android System Extreme Tweaks
optimize_android_extreme() {
    echo "🤖 ANDROID EXTREME OPTIMIZATION..."
    
    # SurfaceFlinger ULTRA settings
    setprop debug.sf.enable_hwc_vds "1"
    setprop debug.sf.latch_unsignaled "1"
    setprop debug.sf.disable_backpressure "1"
    setprop debug.sf.early_phase_offset_ns "500000"
    setprop debug.sf.early_app_phase_offset_ns "500000"
    setprop debug.sf.early_gl_phase_offset_ns "300000"
    setprop debug.sf.early_gl_app_phase_offset_ns "15000000"
    setprop ro.surface_flinger.max_frame_buffer_acquired_buffers "3"
    setprop ro.surface_flinger.use_smart_90_for_video "1"
    setprop ro.surface_flinger.max_virtual_display_dimension "8192"
    
    # HWUI ULTRA settings
    setprop ro.hwui.texture_cache_size "512"
    setprop ro.hwui.layer_cache_size "256"
    setprop ro.hwui.path_cache_size "64"
    setprop ro.hwui.texture_cache_flushrate "0.2"
    setprop ro.hwui.shape_cache_size "8"
    setprop ro.hwui.gradient_cache_size "4"
    setprop ro.hwui.drop_shadow_cache_size "16"
    setprop ro.hwui.r_buffer_cache_size "32"
    
    # Disable ALL debugging and logging
    setprop debug.egl.hw "0"
    setprop debug.sf.hw "0"
    setprop debug.qualcomm.sns.daemon "0"
    setprop debug.enable.gamed "0"
    setprop debug.mdpcomp.logs "0"
    setprop persist.vendor.disable.core.sharing "1"
    setprop persist.vendor.camera.hal.debug "0"
    setprop persist.vendor.ims.disableDebugLogs "1"
    setprop logd.logenable "0"
    setprop persist.logd.logpersistd "disable"
    
    # Game Driver ULTRA
    setprop ro.config.game_mode "true"
    setprop persist.performance.profile "1"
    setprop persist.vendor.games.gt.prof "1"
    setprop ro.product.gpu.model "true"
    setprop ro.qualcomm.cabl "0"
    setprop ro.vendor.power.density "300"
    setprop persist.vendor.dfps.level "90"
    
    # Disable vsync for MAX FPS
    setprop debug.egl.swapinterval "0"
    setprop persist.debug.egl.swapinterval "0"
    
    # Enable hardware acceleration everywhere
    setprop video.accelerate.hw "1"
    setprop debug.performance.tuning "1"
    
    # Reduce touch latency
    setprop persist.vendor.touch.delay.calm "0"
    setprop persist.vendor.touch.delay.idle "0"
    setprop persist.vendor.touch.delay.busy "0"
    
    echo "✅ Android extreme optimization complete"
}

# Activate ULTIMATE Gaming Mode
activate_ultimate_gaming_mode() {
    echo "🎮 ACTIVATING ULTIMATE GAMING MODE..."
    
    # Game Driver settings
    settings put global game_driver_all_apps 1
    settings put global game_driver_opt_in 1
    settings put global game_driver_prerelease_all_apps 1
    settings put global development_settings_enabled 0
    
    # Disable ALL animations
    settings put global animator_duration_scale 0.0
    settings put global transition_animation_scale 0.0
    settings put global window_animation_scale 0.0
    
    # Disable adaptive features
    settings put global adaptive_battery_management_enabled 0
    settings put global adaptive_sleep 0
    settings put global adaptive_charging 0
    
    # Disable battery optimizations
    settings put global app_standby_enabled 0
    settings put global battery_saver_constants "disable=1"
    
    # Disable data saver
    settings put global data_saver_backup_whitelist "*"
    
    # Performance mode
    settings put global performance_mode 2
    settings put global game_mode 1
    settings put global game_overlay 0
    
    # Disable automatic updates
    settings put global package_verifier_enable 0
    settings put global upload_log 0
    settings put global auto_time 0
    settings put global auto_time_zone 0
    
    # Disable location during gaming
    settings put secure location_mode 0
    
    echo "✅ Ultimate Gaming Mode Activated"
}

# Main execution - FULL PERFORMANCE
main() {
    echo "🔥 STARTING ULTIMATE GAMING PERFORMANCE BOOST 🔥"
    echo "⚠️  WARNING: This will disable thermal protection!"
    echo "=========================================="
    
    # Stop power HAL immediately
    stop vendor.power-hal-1-0 2>/dev/null
    stop vendor.power-hal-1-1 2>/dev/null
    stop power-hal-1-2 2>/dev/null
    stop power-hal 2>/dev/null
    
    # Apply optimizations in aggressive order
    echo ""
    echo "🔄 Applying optimizations..."
    echo "=========================================="
    
    # Phase 1: Kill everything unnecessary
    kill_background_processes
    
    # Phase 2: Disable protections
    disable_thermal_throttle
    
    # Phase 3: Force hardware to MAX
    force_max_cpu
    force_max_gpu
    
    # Phase 4: System optimizations
    optimize_memory_extreme
    optimize_io_ultimate
    optimize_network_extreme
    optimize_android_extreme
    
    # Phase 5: Gaming mode
    activate_ultimate_gaming_mode
    
    # Final sync
    sync
    echo 3 > /proc/sys/vm/drop_caches 2>/dev/null
    
    echo ""
    echo "=========================================="
    echo "🎮 ULTIMATE GAMING MODE ACTIVATED! 🎮"
    echo "=========================================="
    echo ""
    echo "✅ ALL OPTIMIZATIONS APPLIED:"
    echo "   • CPU: Locked at MAX frequency"
    echo "   • GPU: Maximum performance mode"
    echo "   • Thermal: Throttling DISABLED"
    echo "   • Memory: Extreme gaming profile"
    echo "   • I/O: Ultra-fast storage"
    echo "   • Network: Gaming optimized"
    echo "   • System: All animations disabled"
    echo ""
    echo "⚠️  WARNING: Device may run HOT"
    echo "⚠️  Use only during gaming sessions!"
    echo ""
    echo "📊 To check status:"
    echo "   CPU: cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq"
    echo "   GPU: cat /sys/class/kgsl/kgsl-3d0/gpuclk"
    echo ""
    
    return 0
}

# Execute
main "$@"

# Daemon mode to keep optimizations
if [[ "$1" == "--daemon" ]] || [[ "$2" == "--daemon" ]]; then
    echo "🔄 Starting ULTIMATE PERFORMANCE DAEMON..."
    echo "🔒 Locking CPU/GPU at MAX frequencies..."
    
    while true; do
        # Keep CPU at performance governor
        for cpu in /sys/devices/system/cpu/cpu*/cpufreq/scaling_governor; do
            [[ -f "$cpu" ]] && echo "performance" > "$cpu" 2>/dev/null
        done
        
        # Keep CPU at max frequency
        for cpu in /sys/devices/system/cpu/cpu*/cpufreq; do
            if [[ -d "$cpu" ]]; then
                local max_freq=$(cat "$cpu/cpuinfo_max_freq" 2>/dev/null)
                [[ -n "$max_freq" ]] && {
                    echo "$max_freq" > "$cpu/scaling_max_freq" 2>/dev/null
                    echo "$max_freq" > "$cpu/scaling_min_freq" 2>/dev/null
                }
            fi
        done
        
        # Keep GPU awake
        for gpu in /sys/class/kgsl/kgsl-3d0; do
            [[ -d "$gpu" ]] && {
                [[ -f "$gpu/force_no_nap" ]] && echo "1" > "$gpu/force_no_nap" 2>/dev/null
                [[ -f "$gpu/force_clk_on" ]] && echo "1" > "$gpu/force_clk_on" 2>/dev/null
            }
        done
        
        # Clear memory cache periodically
        sync
        echo 1 > /proc/sys/vm/drop_caches 2>/dev/null
        
        sleep 10
    done
fi